package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProviderRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateCapitalOldHoldHarmlessAmount
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final ProviderRecord providerRecord = calculationContext.getProviderRecord();

    // ***********************************************************
    // ***********  CAPITAL OLD-HOLD-HARMLESS CALCULATION ***********
    // ***********  CAPITAL OLD-HOLD-HARMLESS CALCULATION ***********
    //     COMPUTE H-CAPI-OLD-HARMLESS ROUNDED =
    //                    (P-NEW-CAPI-OLD-HARM-RATE *
    //                    H-CAPI-SCH).
    if (providerRecord.getOldCapitalHoldHarmlessRate() != null) {
      calculationContext.setCapitalOldHoldHarmless(
          providerRecord
              .getOldCapitalHoldHarmlessRate()
              .multiply(calculationContext.getCapitalSch())
              .setScale(2, RoundingMode.HALF_UP));
    } else {
      calculationContext.setCapitalOldHoldHarmless(BigDecimal.ZERO);
    }
  }
}
