package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.util.List;

/**
 * Encapsulates the claim's eligibility determination for a calculated operating disproportionate
 * share hospital adjustment as a sub-sequence of rules.
 *
 * <p>Converted from {@code 3900A-CALC-OPER-DSH} in the COBOL code.
 */
public class CalculateOperatingDisproportionateShare
    extends EvaluatingCalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  public CalculateOperatingDisproportionateShare(
      List<CalculationRule<IppsInput, IppsOutput, IppsPricerContext>> calculationRules) {
    super(calculationRules);
  }
}
