package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.BillingRecord;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProspectivePaymentRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;

/**
 * Determines the regular or lifetime reserve days utilized during the stay.
 *
 * <p>Converted from {@code 3100-CALC-STAY-UTILIZATION} in the COBOL code.
 *
 * @since 2019
 */
public class CalculateStayUtilization
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final BillingRecord billingRecord = calculationContext.getBillingRecord();
    final ProspectivePaymentRecord prospectivePaymentRecord =
        calculationContext.getProspectivePaymentRecord();

    //     MOVE 0 TO PPS-REG-DAYS-USED.
    //     MOVE 0 TO PPS-LTR-DAYS-USED.
    //
    //     IF H-REG-DAYS > 0
    //        IF H-REG-DAYS > B-LOS
    //           MOVE B-LOS TO PPS-REG-DAYS-USED
    //        ELSE
    //           MOVE H-REG-DAYS TO PPS-REG-DAYS-USED
    //     ELSE
    //        IF H-LTR-DAYS > B-LOS
    //           MOVE B-LOS TO PPS-LTR-DAYS-USED
    //        ELSE
    //           MOVE H-LTR-DAYS TO PPS-LTR-DAYS-USED.
    if (calculationContext.getRegularDays() > 0) {
      if (calculationContext.getRegularDays() > billingRecord.getLengthOfStay()) {
        prospectivePaymentRecord.setRegDaysUsed(billingRecord.getLengthOfStay());
      } else {
        prospectivePaymentRecord.setRegDaysUsed(calculationContext.getRegularDays());
      }
    } else if (billingRecord.getLifetimeReserveDays() > billingRecord.getLengthOfStay()) {
      prospectivePaymentRecord.setLtrDaysUsed(billingRecord.getLengthOfStay());
    } else {
      prospectivePaymentRecord.setLtrDaysUsed(billingRecord.getLifetimeReserveDays());
    }
  }
}
