package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProspectivePaymentRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;

/**
 * Initialize fields used in payment calculations.
 *
 * <p>Converted from {@code 3000-CALC-PAYMENT} in the COBOL code (continued).
 *
 * @since 2019
 */
public class InitializeCalculationFields
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final ProspectivePaymentRecord prospectivePaymentRecord =
        calculationContext.getProspectivePaymentRecord();

    // ***********************************************************
    //     MOVE 00                 TO  PPS-RTC.
    //     MOVE H-WAGE-INDEX       TO  PPS-WAGE-INDX.
    //     MOVE H-ALOS             TO  PPS-AVG-LOS.
    //     MOVE H-DAYS-CUTOFF      TO  PPS-DAYS-CUTOFF.
    //     MOVE B-LOS TO H-PERDIEM-DAYS.
    calculationContext.applyResultCode(ResultCode.RC_00_OK);
    prospectivePaymentRecord.setWageIndx(calculationContext.getCbsaReference().getWageIndex());
    prospectivePaymentRecord.setAvgLos(
        calculationContext.getDrgsTableEntry().getGeometricMeanLengthOfStay());
    prospectivePaymentRecord.setDaysCutoff(new BigDecimal("0.0"));
    BigDecimal perdiemDays =
        BigDecimal.valueOf(calculationContext.getBillingRecord().getLengthOfStay());

    //     IF H-PERDIEM-DAYS < 1
    //         MOVE 1 TO H-PERDIEM-DAYS.
    if (BigDecimalUtils.isLessThan(perdiemDays, BigDecimal.ONE)) {
      perdiemDays = BigDecimal.ONE;
    }

    //     ADD 1 TO H-PERDIEM-DAYS.
    calculationContext.setPerDiemDays(perdiemDays.add(BigDecimal.ONE));
  }
}
