package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.util.List;

/**
 * Encapsulates post-outlier processing calculations as a sub-sequence of rules.
 *
 * <p>Converted from {@code 3000-CALC-PAYMENT} in the COBOL code (continued).
 *
 * @since 2019
 */
public class PostProcessOutlierCosts
    extends EvaluatingCalculationRule<IppsInput, IppsOutput, IppsPricerContext> {
  public PostProcessOutlierCosts(
      List<CalculationRule<IppsInput, IppsOutput, IppsPricerContext>> list) {
    super(list);
  }

  @Override
  public boolean shouldExecute(IppsPricerContext calculationContext) {
    return !calculationContext.isOutlierReconciliation();
  }
}
