package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProviderRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;

/**
 * Determine the HMO calculation for pass through add-on amount.
 *
 * <p>Converted from {@code 3850-HMO-IME-ADJ} in the COBOL code.
 *
 * @since 2019
 */
public class CalculateHmoTotals
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public boolean shouldExecute(IppsPricerContext calculationContext) {
    //     IF HMO-TAG  = 'Y'
    //        PERFORM 3850-HMO-IME-ADJ.
    return calculationContext.isHmoClaim();
  }

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final ProviderRecord providerRecord = calculationContext.getProviderRecord();

    // ***********************************************************
    // ***  HMO CALC FOR PASS-THRU ADDON
    //     COMPUTE H-WK-PASS-AMT-PLUS-MISC ROUNDED =
    //          (P-NEW-PASS-AMT-PLUS-MISC -
    //          (P-NEW-PASS-AMT-ORGAN-ACQ +
    //           P-NEW-PASS-AMT-DIR-MED-ED)) * B-LOS.
    calculationContext.setPassthroughAmountPlusMisc(
        providerRecord
            .getPassthruAmountPlusMisc()
            .subtract(
                providerRecord
                    .getPassthruAmountOrganAcquisition()
                    .add(providerRecord.getPassthruAmountDirectMedicalEducation()))
            .multiply(BigDecimal.valueOf(calculationContext.getBillingRecord().getLengthOfStay())));

    // ***********************************************************
    // ***  HMO IME ADJUSTMENT --- NO LONGER PAID AS OF 10/01/2002
    //     COMPUTE PPS-OPER-IME-ADJ ROUNDED =
    //                   PPS-OPER-IME-ADJ * .0.
    calculationContext.getProspectivePaymentRecord().setOperImeAdj(BigDecimalUtils.ZERO);
  }
}
