package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProspectivePaymentRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;

/**
 * Determine the operating outlier part amount.
 *
 * <p>Converted from {@code 3800-CALC-TOT-AMT} in the COBOL code.
 *
 * @since 2019
 */
public class CalculateOperatingTotals
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final ProspectivePaymentRecord prospectivePaymentRecord =
        calculationContext.getProspectivePaymentRecord();

    // ***********************************************************
    // ***  CALCULATE FINAL TOTALS FOR OPERATING
    //     IF (H-CAPI-OUTLIER > 0 AND
    //         PPS-OPER-OUTLIER-PART = 0)
    //            COMPUTE PPS-OPER-OUTLIER-PART =
    //                    PPS-OPER-OUTLIER-PART + .01.
    if (BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalOutlierCost())
        && BigDecimalUtils.isZero(prospectivePaymentRecord.getOperOutlierPart())) {
      prospectivePaymentRecord.setOperOutlierPart(
          prospectivePaymentRecord.getOperOutlierPart().add(new BigDecimal("0.01")));
    }
  }
}
