package gov.cms.fiss.pricers.ipps.core.rules.rules2021;

import gov.cms.fiss.pricers.ipps.api.AdditionalVariables;
import gov.cms.fiss.pricers.ipps.api.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.rules.DefaultAdditionalVariableUpdate;
import java.math.RoundingMode;
import java.util.Optional;

/**
 * Initializes secondary variables for the claim response, including COVID and other modifications.
 *
 * <p>Converted from the {@code PPCAL} module in the COBOL code.
 *
 * @since 2019
 */
public class AdditionalVariableUpdate2021 extends DefaultAdditionalVariableUpdate {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    super.priceClaim(calculationContext);
    final AdditionalVariables additionalVariables = calculationContext.getAdditionalVariables();

    // COMPUTE H-DRG-WT ROUNDED = H-DRG-WT * COVID-ADJ * NO-COST-PRODUCT.

    additionalVariables.setDrgWT(
        Optional.ofNullable(calculationContext.getDrgsTableEntry())
            .orElse(new DrgsTableEntry())
            .getWeight()
            .multiply(calculationContext.getCovidAdjustmentFactor())
            .multiply(calculationContext.getNoCostProductAdjustmentFactor())
            .setScale(4, RoundingMode.HALF_UP));

    // COMPUTE H-DRG-WT-FRCTN ROUNDED = H-DRG-WT-FRCTN * COVID-ADJ * NO-COST-PRODUCT.

    additionalVariables.setDrgWTFraction(
        calculationContext
            .getDrgWeightFraction()
            .multiply(calculationContext.getCovidAdjustmentFactor())
            .multiply(calculationContext.getNoCostProductAdjustmentFactor())
            .setScale(4, RoundingMode.HALF_UP));

    additionalVariables.setOperDollarThreshold(
        calculationContext.getOperatingChargeThreshold().setScale(9, RoundingMode.HALF_UP));
  }
}
