package gov.cms.fiss.pricers.ipps.core.rules.rules2022.cost_factor_determination.ratex;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.api.ProviderRecord;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.rules.cost_factor_determination.ratex.DetermineRateTableWithReduction;
import org.apache.commons.lang3.StringUtils;

/**
 * Determines the rate table to utilize for a claim when there is an EHR reduction.
 *
 * <p>Converted from {@code 2050-RATES-TB} in the COBOL code (continued).
 *
 * @since 2019
 */
public class DetermineRateTableWithReduction2022 extends DetermineRateTableWithReduction
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    super.priceClaim(calculationContext);

    final ProviderRecord providerRecord = calculationContext.getProviderRecord();

    if (StringUtils.equals(providerRecord.getNewStateCode(), "40")
        && StringUtils.equals(providerRecord.getEhrReductionIndicator(), "Y")) {
      calculationContext.setRatexTable("tab10");
    }
  }
}
