package gov.cms.fiss.pricers.ipps.core.rules.rules2022.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.CbsaTableEntry;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;

/**
 * Determines the value of the wage index based on comparison to the imputed floor wage index.
 *
 * @since 2022
 */
public class AdjustIndexForImputedFloor2022
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final CbsaReference cbsaReference = calculationContext.getCbsaReference();
    final DataTables dataTables = calculationContext.getDataTables();

    final CbsaTableEntry imputedCbsaTableEntry =
        dataTables.getCbsaWageIndex(
            calculationContext.getStateCode(), calculationContext.getDischargeDate());

    if (imputedCbsaTableEntry != null
        && BigDecimalUtils.isGreaterThanZero(imputedCbsaTableEntry.getImputedFloorWageIndex())
        && BigDecimalUtils.isGreaterThan(
            imputedCbsaTableEntry.getImputedFloorWageIndex(), cbsaReference.getWageIndex())) {
      cbsaReference.setCbsa(imputedCbsaTableEntry.getCbsa());
      cbsaReference.setEffectiveDate(imputedCbsaTableEntry.getEffectiveDate());
      cbsaReference.setWageIndex(imputedCbsaTableEntry.getImputedFloorWageIndex());
    }
  }
}
