package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.util.List;

/**
 * Performs wage index adjustments as a sub-sequence of rules.
 *
 * <p>Converted from {@code 0550-GET-CBSA} in the COBOL code (continued).
 *
 * @since 2019
 */
public class AdjustWageIndex
    extends EvaluatingCalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  public AdjustWageIndex(
      List<CalculationRule<IppsInput, IppsOutput, IppsPricerContext>> calculationRules) {
    super(calculationRules);
  }

  @Override
  public boolean shouldExecute(IppsPricerContext calculationContext) {
    return calculationContext.getResultCode() != ResultCode.RC_52_INVALID_WAGE_INDEX
        && !IppsPricerContext.SPECIAL_WAGE_INDEX_CBSA.equals(
            calculationContext.getCbsaReference().getCbsa());
  }
}
