package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.CbsaData;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import org.apache.commons.lang3.StringUtils;

/**
 * Ensures the CBSA locations are populated with valid content.
 *
 * <p>Converted from {@code 0030-GET-WAGE-INDEX} in the COBOL code (continued).
 *
 * @since 2019
 */
public class PopulateCbsaLocations
    implements CalculationRule<IppsInput, IppsOutput, IppsPricerContext> {
  @Override
  public void priceClaim(IppsPricerContext calculationContext) {
    final CbsaData cbsaData = calculationContext.getCbsaData();

    //     IF P-NEW-EFF-DATE > 20040930
    //        IF (P-NEW-CBSA-RECLASS-LOC = '     ' OR
    //            P-NEW-CBSA-RECLASS-LOC = '00000')
    //            MOVE P-NEW-CBSA-GEO-LOC9 TO P-NEW-CBSA-RECLASS-LOC.
    if (StringUtils.isBlank(cbsaData.getReclassifiedLocation())
        || cbsaData.getReclassifiedLocation().equals(IppsPricerContext.ZEROS)) {
      cbsaData.setReclassifiedLocation(StringUtils.trim(cbsaData.getGeolocation()));
    }

    //     IF P-NEW-EFF-DATE > 20040930
    //        IF (P-NEW-CBSA-STAND-AMT-LOC = '     ' OR
    //            P-NEW-CBSA-STAND-AMT-LOC = '00000')
    //            MOVE P-NEW-CBSA-GEO-LOC9 TO P-NEW-CBSA-STAND-AMT-LOC.
    if (StringUtils.isBlank(cbsaData.getStandardAmountLocation())
        || cbsaData.getStandardAmountLocation().equals(IppsPricerContext.ZEROS)) {
      cbsaData.setStandardAmountLocation(StringUtils.trim(cbsaData.getGeolocation()));
    }
  }
}
