package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.IppsInput;
import gov.cms.fiss.pricers.ipps.api.IppsOutput;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.util.List;

/**
 * Encapsulates the outmigration, CBSA, and special wage index determinations as a sub-sequence of
 * rules.
 *
 * <p>Converted from {@code 0030-GET-WAGE-INDEX} in the COBOL code.
 *
 * @since 2019
 */
public class WageIndexDerivation
    extends EvaluatingCalculationRule<IppsInput, IppsOutput, IppsPricerContext> {

  public WageIndexDerivation(
      List<CalculationRule<IppsInput, IppsOutput, IppsPricerContext>> calculationRules) {
    super(calculationRules);
  }
}
