// Generated by delombok at Mon Oct 04 13:52:55 EDT 2021
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.dataformat.csv.CsvParser.Feature;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.util.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.util.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.util.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.api.CbsaTableEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * Creates the lookup table needed for CBSA per-year data.
 */
public class CbsaTableEntryLookupGenerator {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(CbsaTableEntryLookupGenerator.class);
  private static final String CSV_FILE_PATTERN = "/cbsa-%s.csv";
  private final CsvContentReader<CbsaTableEntry> contentProvider = new CsvContentReader<>(CbsaTableEntry.class);

  public CbsaTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
    if (!csvIngestionConfiguration.isValidationEnabled()) {
      contentProvider.disableValidation();
    }
    contentProvider.customizeMapper(mapper -> mapper.disable(Feature.FAIL_ON_MISSING_COLUMNS));
    contentProvider.withSchema(CsvSchema.emptySchema().withHeader());
  }

  /**
   * Generates the lookup cross-reference for the specified pricer year.
   *
   * @param pricerYear the year to reference
   * @return the generated lookup
   */
  public Map<String, NavigableMap<LocalDate, CbsaTableEntry>> generate(int pricerYear) {
    return generate(String.format(CSV_FILE_PATTERN, pricerYear));
  }

  /**
   * Generates the lookup cross-reference from the specified source.
   *
   * @param csvFilename the file to process
   * @return the generated lookup
   */
  public Map<String, NavigableMap<LocalDate, CbsaTableEntry>> generate(String csvFilename) {
    final List<CbsaTableEntry> content = contentProvider.read(csvFilename);
    // This comparison is a no-op, as there is no chance of merge conflicts here
    final BinaryOperator<CbsaTableEntry> comparator = BinaryOperator.maxBy((a, b) -> 0);
    final Collector<CbsaTableEntry, ?, NavigableMap<LocalDate, CbsaTableEntry>> collector = Collectors.toMap(CbsaTableEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
    return LookupGenerator.generateCrossReferenceToMap(CbsaTableEntry::getCbsa, content, HashMap::new, collector);
  }
}
