// Generated by delombok at Mon Oct 04 13:52:55 EDT 2021
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.common.util.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.ipps.IppsPricerConfiguration;
import gov.cms.fiss.pricers.ipps.api.CbsaTableEntry;
import gov.cms.fiss.pricers.ipps.api.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.RatexTableEntry.RatexKey;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

/**
 * Provides an encapsulation of the static lookup data for the pricer. Each instance is expected to
 * support one pricer year.
 */
public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  private final Map<String, NavigableMap<LocalDate, CbsaTableEntry>> cbsaTable;
  private final Map<String, NavigableMap<LocalDate, DrgsTableEntry>> drgsTable;
  private final Map<String, MidnightTableEntry> midnightTable;
  private final Map<String, Map<ClaimCodeType, List<String>>> claimCodeTable;
  private final Map<String, NewTechnologyAmountTableEntry> newTechnologyAmountTable;
  private final Map<String, NavigableMap<LocalDate, OutMigrationTableEntry>> outMigrationTable;
  private final Map<String, PrevYearWIFY19TableEntry> prevYearWIFY19Table;
  private final Map<RatexKey, RatexTableEntry> ratexTable;
  private final Map<String, RuralFloorTableEntry> ruralfloorTable;

  public DataTables(Map<String, NavigableMap<LocalDate, CbsaTableEntry>> cbsaTable, Map<String, NavigableMap<LocalDate, DrgsTableEntry>> drgsTable, Map<String, MidnightTableEntry> midnightTable, Map<String, Map<ClaimCodeType, List<String>>> claimCodeTable, Map<String, NewTechnologyAmountTableEntry> newTechnologyAmountTable, Map<String, NavigableMap<LocalDate, OutMigrationTableEntry>> outMigrationTable, Map<String, PrevYearWIFY19TableEntry> prevYearWIFY19Table, Map<RatexKey, RatexTableEntry> ratexTable, Map<String, RuralFloorTableEntry> ruralfloorTable) {
    this.cbsaTable = cbsaTable;
    this.drgsTable = drgsTable;
    this.midnightTable = midnightTable;
    this.claimCodeTable = claimCodeTable;
    this.newTechnologyAmountTable = newTechnologyAmountTable;
    this.outMigrationTable = outMigrationTable;
    this.prevYearWIFY19Table = prevYearWIFY19Table;
    this.ratexTable = ratexTable;
    this.ruralfloorTable = ruralfloorTable;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables.
   *
   * @param pricerConfiguration the pricer configuration to use
   */
  public static void loadDataTables(IppsPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final Map<String, MidnightTableEntry> midnightTable = new MidnightTableEntryLookupGenerator(csvIngestionConfiguration).generate();
    final CbsaTableEntryLookupGenerator cbsaLookupGenerator = new CbsaTableEntryLookupGenerator(csvIngestionConfiguration);
    final DrgsTableEntryLookupGenerator drgsLookupGenerator = new DrgsTableEntryLookupGenerator(csvIngestionConfiguration);
    final ClaimCodeTableEntryLookupGenerator claimCodeLookupGenerator = new ClaimCodeTableEntryLookupGenerator(csvIngestionConfiguration);
    final NewTechnologyAmountTableEntryLookupGenerator newTechnologyAmountLookupGenerator = new NewTechnologyAmountTableEntryLookupGenerator(csvIngestionConfiguration);
    final OutMigrationTableEntryLookupGenerator outMigrationLookupGenerator = new OutMigrationTableEntryLookupGenerator(csvIngestionConfiguration);
    final PrevYearWIFY19TableEntryLookupGenerator prevYearWIFY19LookupGenerator = new PrevYearWIFY19TableEntryLookupGenerator(csvIngestionConfiguration);
    final RatexTableEntryLookupGenerator ratexLookupGenerator = new RatexTableEntryLookupGenerator(csvIngestionConfiguration);
    final RuralFloorTableEntryLookupGenerator ruralFloorLookupGenerator = new RuralFloorTableEntryLookupGenerator(csvIngestionConfiguration);
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaLookupGenerator.generate(pricerYear), drgsLookupGenerator.generate(pricerYear), midnightTable, claimCodeLookupGenerator.generate(pricerYear), newTechnologyAmountLookupGenerator.generate(pricerYear), outMigrationLookupGenerator.generate(pricerYear), prevYearWIFY19LookupGenerator.generate(pricerYear), ratexLookupGenerator.generate(pricerYear), ruralFloorLookupGenerator.generate(pricerYear)));
    }
  }

  public CbsaTableEntry getCbsaWageIndex(String cbsa, LocalDate effectiveDate) {
    final NavigableMap<LocalDate, CbsaTableEntry> entries = cbsaTable.get(cbsa);
    if (entries != null) {
      final Entry<LocalDate, CbsaTableEntry> entry = entries.floorEntry(effectiveDate);
      return null == entry ? null : entry.getValue();
    }
    return null;
  }

  public DrgsTableEntry getDrgsEntry(String code, LocalDate effectiveDate) {
    final NavigableMap<LocalDate, DrgsTableEntry> entries = drgsTable.get(StringUtils.leftPad(code, 3, "0"));
    if (entries != null) {
      final Entry<LocalDate, DrgsTableEntry> entry = entries.floorEntry(effectiveDate);
      return null == entry ? null : entry.getValue();
    }
    return null;
  }

  public MidnightTableEntry getMidnightEntry(String msa) {
    return midnightTable.get(msa);
  }

  public NewTechnologyAmountTableEntry getNewTechnologyAmount(String referenceName) {
    return newTechnologyAmountTable.get(referenceName);
  }

  /**
   * Obtains the matching codes that relate to a conceptual reference name, such as a technology
   * classification or treatment type.
   *
   * @param referenceName the reference name for the code aggregation
   * @param codeType the type of code to match
   * @return all codes matching the technology
   */
  public List<String> getClaimCodes(String referenceName, ClaimCodeType codeType) {
    final Map<ClaimCodeType, List<String>> codeTypeReference = claimCodeTable.get(referenceName);
    if (null != codeTypeReference) {
      return codeTypeReference.getOrDefault(codeType, new ArrayList<>());
    }
    return new ArrayList<>();
  }

  /**
   * Determines how many codes from the claim match for a conceptual reference name, such as a *
   * technology classification or treatment type.
   *
   * @param referenceName the reference name for the code aggregation
   * @param codeType the type of code to match
   * @param providedCodes the codes from the claim
   * @return the number of matches; returns {@code 0} if no codes are provided
   */
  public int countMatchingCodes(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
    final List<String> referenceCodes = getClaimCodes(referenceName, codeType);
    return (int) Optional.ofNullable(providedCodes).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).collect(Collectors.toSet()).stream().filter(referenceCodes::contains).count();
  }

  /**
   * Determines if any of the codes from the claim match for a conceptual reference name, such as a
   * technology classification or treatment type.
   *
   * @param referenceName the reference name for the code aggregation
   * @param codeType the type of code to match
   * @param providedCodes the codes from the claim
   * @return {@code true} if any of the claim codes match; {@code false} otherwise
   */
  public boolean codesMatch(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
    final List<String> referenceCodes = getClaimCodes(referenceName, codeType);
    return Optional.ofNullable(providedCodes).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).anyMatch(referenceCodes::contains);
  }

  /**
   * Determines if any of the codes from the claim match for all reference groups using the name
   * prefix. This requires that at least one code from the claim match each of the reference groups
   * starting with the provided prefix.
   *
   * @param referenceName the reference name for the code aggregation (used as a prefix)
   * @param codeType the type of code to match
   * @param providedCodes the codes from the claim
   * @return {@code true} if any of the claim codes match; {@code false} otherwise
   */
  public boolean codesMatchAll(String referenceName, ClaimCodeType codeType, List<String> providedCodes) {
    final List<String> referenceNames = claimCodeTable.keySet().stream().filter(k -> k.startsWith(referenceName)).collect(Collectors.toList());
    return referenceNames.stream().allMatch(rn -> codesMatch(rn, codeType, providedCodes));
  }

  public OutMigrationTableEntry getOutMigrationEntry(String county, LocalDate dischargeDate, LocalDate fyBeginDate) {
    final NavigableMap<LocalDate, OutMigrationTableEntry> entries = outMigrationTable.get(county);
    if (entries == null) {
      return null;
    }
    final Entry<LocalDate, OutMigrationTableEntry> entry = entries.floorEntry(dischargeDate);
    if (null != entry && LocalDateUtils.isAfterOrEqual(entry.getKey(), fyBeginDate)) {
      return entry.getValue();
    }
    return null;
  }

  public PrevYearWIFY19TableEntry getPrevWageIndex(String providerNumber) {
    return prevYearWIFY19Table.get(providerNumber);
  }

  public RatexTableEntry getRatexIndex(String table, RatexTableEntry.Scope scope, boolean isLargeUrban) {
    return ratexTable.get(new RatexKey(table, scope, isLargeUrban));
  }

  public RuralFloorTableEntry getRuralFloorIndex(String cbsa) {
    return this.ruralfloorTable.get(cbsa);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaTableEntry>> getCbsaTable() {
    return this.cbsaTable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, DrgsTableEntry>> getDrgsTable() {
    return this.drgsTable;
  }
}
