// Generated by delombok at Mon Oct 04 13:52:55 EDT 2021
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import gov.cms.fiss.pricers.ipps.core.tables.RatexTableEntry.Fields;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;

@JsonPropertyOrder({Fields.TABLE_NUMBER, Fields.SCOPE, Fields.LARGE_URBAN, Fields.REG_LABOR, Fields.REG_N_LABOR})
public class RatexTableEntry {
  @Pattern(regexp = "tab\\d+")
  private String tableNumber;
  private Scope scope;
  @Max(2)
  @Min(1)
  private int largeUrban;
  @Digits(integer = 5, fraction = 2)
  private BigDecimal regLabor;
  @Digits(integer = 5, fraction = 2)
  private BigDecimal regNLabor;

  public void setScope(String scope) {
    this.scope = Scope.fromReference(scope);
  }

  public boolean isLargeUrban() {
    return Objects.equals(largeUrban, 1);
  }


  /**
   * Representation of the scope of a rate table entry.
   */
  public enum Scope {
    NAT("nat"), PR("pr"), NAT_PR("natpr");
    private final String referenceName;

    Scope(String referenceName) {
      this.referenceName = referenceName;
    }

    public static Scope fromReference(String referenceName) {
      for (final Scope scope : Scope.values()) {
        if (scope.referenceName.equals(referenceName)) {
          return scope;
        }
      }
      throw new IllegalArgumentException("Invalid scope reference: " + referenceName);
    }
  }


  /**
   * Multi-part key for a rate table entry.
   */
  public static final class RatexKey {
    private final String table;
    private final Scope scope;
    private final boolean isLargeUrban;

    public static RatexKey fromRatex(RatexTableEntry ratexTableEntry) {
      return new RatexKey(ratexTableEntry.getTableNumber(), ratexTableEntry.getScope(), ratexTableEntry.isLargeUrban());
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RatexKey(final String table, final Scope scope, final boolean isLargeUrban) {
      this.table = table;
      this.scope = scope;
      this.isLargeUrban = isLargeUrban;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTable() {
      return this.table;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Scope getScope() {
      return this.scope;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isLargeUrban() {
      return this.isLargeUrban;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
      if (o == this) return true;
      if (!(o instanceof RatexTableEntry.RatexKey)) return false;
      final RatexTableEntry.RatexKey other = (RatexTableEntry.RatexKey) o;
      if (this.isLargeUrban() != other.isLargeUrban()) return false;
      final java.lang.Object this$table = this.getTable();
      final java.lang.Object other$table = other.getTable();
      if (this$table == null ? other$table != null : !this$table.equals(other$table)) return false;
      final java.lang.Object this$scope = this.getScope();
      final java.lang.Object other$scope = other.getScope();
      if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) return false;
      return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
      final int PRIME = 59;
      int result = 1;
      result = result * PRIME + (this.isLargeUrban() ? 79 : 97);
      final java.lang.Object $table = this.getTable();
      result = result * PRIME + ($table == null ? 43 : $table.hashCode());
      final java.lang.Object $scope = this.getScope();
      result = result * PRIME + ($scope == null ? 43 : $scope.hashCode());
      return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "RatexTableEntry.RatexKey(table=" + this.getTable() + ", scope=" + this.getScope() + ", isLargeUrban=" + this.isLargeUrban() + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTableNumber() {
    return this.tableNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Scope getScope() {
    return this.scope;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLargeUrban() {
    return this.largeUrban;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegLabor() {
    return this.regLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegNLabor() {
    return this.regNLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTableNumber(final String tableNumber) {
    this.tableNumber = tableNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLargeUrban(final int largeUrban) {
    this.largeUrban = largeUrban;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegLabor(final BigDecimal regLabor) {
    this.regLabor = regLabor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegNLabor(final BigDecimal regNLabor) {
    this.regNLabor = regNLabor;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof RatexTableEntry)) return false;
    final RatexTableEntry other = (RatexTableEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getLargeUrban() != other.getLargeUrban()) return false;
    final java.lang.Object this$tableNumber = this.getTableNumber();
    final java.lang.Object other$tableNumber = other.getTableNumber();
    if (this$tableNumber == null ? other$tableNumber != null : !this$tableNumber.equals(other$tableNumber)) return false;
    final java.lang.Object this$scope = this.getScope();
    final java.lang.Object other$scope = other.getScope();
    if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) return false;
    final java.lang.Object this$regLabor = this.getRegLabor();
    final java.lang.Object other$regLabor = other.getRegLabor();
    if (this$regLabor == null ? other$regLabor != null : !this$regLabor.equals(other$regLabor)) return false;
    final java.lang.Object this$regNLabor = this.getRegNLabor();
    final java.lang.Object other$regNLabor = other.getRegNLabor();
    if (this$regNLabor == null ? other$regNLabor != null : !this$regNLabor.equals(other$regNLabor)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof RatexTableEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + this.getLargeUrban();
    final java.lang.Object $tableNumber = this.getTableNumber();
    result = result * PRIME + ($tableNumber == null ? 43 : $tableNumber.hashCode());
    final java.lang.Object $scope = this.getScope();
    result = result * PRIME + ($scope == null ? 43 : $scope.hashCode());
    final java.lang.Object $regLabor = this.getRegLabor();
    result = result * PRIME + ($regLabor == null ? 43 : $regLabor.hashCode());
    final java.lang.Object $regNLabor = this.getRegNLabor();
    result = result * PRIME + ($regNLabor == null ? 43 : $regNLabor.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "RatexTableEntry(tableNumber=" + this.getTableNumber() + ", scope=" + this.getScope() + ", largeUrban=" + this.getLargeUrban() + ", regLabor=" + this.getRegLabor() + ", regNLabor=" + this.getRegNLabor() + ")";
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String TABLE_NUMBER = "tableNumber";
    public static final java.lang.String SCOPE = "scope";
    public static final java.lang.String LARGE_URBAN = "largeUrban";
    public static final java.lang.String REG_LABOR = "regLabor";
    public static final java.lang.String REG_N_LABOR = "regNLabor";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RatexTableEntry() {
  }
}
