package gov.cms.fiss.pricers.ipps.resources;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import gov.cms.fiss.pricers.ipps.api.CbsaTableEntry.Fields;
import java.time.LocalDate;

/** Provides formatting hints for the Jackson CSV conversion; used as a mix-in. */
@JsonPropertyOrder({
  Fields.CBSA,
  Fields.SIZE,
  Fields.EFFECTIVE_DATE,
  Fields.GEOGRAPHIC_WAGE_INDEX,
  Fields.RECLASSIFIED_WAGE_INDEX,
  Fields.RURAL_FLOOR_WAGE_INDEX,
  Fields.IMPUTED_FLOOR_WAGE_INDEX,
  Fields.NAME
})
public interface CbsaTableEntryCsvFormatter {
  @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
  LocalDate getEffectiveDate();
}
