/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.core.util.TextBuffer;
import com.fasterxml.jackson.dataformat.csv.CsvReadException;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.CsvValueDecorator;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvDecoder;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Objects;

public class CsvParser
extends ParserMinimalBase {
    private static final int MAX_COLUMNS = 99999;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected static final JacksonFeatureSet<StreamReadCapability> STREAM_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with(StreamReadCapability.UNTYPED_SCALARS);
    protected static final int STATE_DOC_START = 0;
    protected static final int STATE_RECORD_START = 1;
    protected static final int STATE_NEXT_ENTRY = 2;
    protected static final int STATE_NAMED_VALUE = 3;
    protected static final int STATE_UNNAMED_VALUE = 4;
    protected static final int STATE_IN_ARRAY = 5;
    protected static final int STATE_SKIP_EXTRA_COLUMNS = 6;
    protected static final int STATE_MISSING_NAME = 7;
    protected static final int STATE_MISSING_VALUE = 8;
    protected static final int STATE_DOC_END = 9;
    protected ObjectCodec _objectCodec;
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected int _columnCount = 0;
    protected boolean _cfgEmptyStringAsNull;
    protected boolean _cfgEmptyUnquotedStringAsNull;
    protected JsonReadContext _parsingContext;
    protected String _currentName;
    protected String _currentValue;
    protected int _columnIndex;
    protected int _state = 0;
    protected byte[] _binaryValue;
    protected int _arrayValueStart;
    protected String _arrayValue;
    protected String _arraySeparator;
    protected String _nullValue;
    protected final CsvDecoder _reader;
    protected final TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteArrayBuilder;

    public CsvParser(IOContext ctxt, int stdFeatures, int csvFeatures, ObjectCodec codec, Reader reader) {
        super(stdFeatures, ctxt.streamReadConstraints());
        Objects.requireNonNull(reader, "Can not pass `null` as `java.io.Reader` to read from");
        this._objectCodec = codec;
        this._ioContext = ctxt;
        this._formatFeatures = csvFeatures;
        DupDetector dups = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(stdFeatures) ? DupDetector.rootDetector(this) : null;
        this._parsingContext = JsonReadContext.createRootContext(dups);
        this._textBuffer = ctxt.constructReadConstrainedTextBuffer();
        this._reader = new CsvDecoder(this, ctxt, reader, this._schema, this._textBuffer, stdFeatures, csvFeatures);
        this._cfgEmptyStringAsNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(csvFeatures);
        this._cfgEmptyUnquotedStringAsNull = Feature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(csvFeatures);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    @Override
    public boolean requiresCustomCodec() {
        return false;
    }

    @Override
    public boolean canReadObjectId() {
        return false;
    }

    @Override
    public boolean canReadTypeId() {
        return false;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return STREAM_READ_CAPABILITIES;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    @Override
    public void setSchema(FormatSchema schema) {
        if (schema instanceof CsvSchema) {
            this._schema = (CsvSchema)schema;
            this._nullValue = this._schema.getNullValueString();
        } else if (schema == null) {
            this._schema = EMPTY_SCHEMA;
        } else {
            super.setSchema(schema);
        }
        this._columnCount = this._schema.size();
        this._reader.setSchema(this._schema);
    }

    @Override
    public int releaseBuffered(Writer out) throws IOException {
        return this._reader.releaseBuffered(out);
    }

    @Override
    public boolean isClosed() {
        return this._reader.isClosed();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this._reader.close();
            this._ioContext.close();
        }
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonParser overrideFormatFeatures(int values, int mask) {
        int oldF = this._formatFeatures;
        int newF = this._formatFeatures & ~mask | values & mask;
        if (oldF != newF) {
            this._formatFeatures = newF;
            this._reader.overrideFormatFeatures(newF);
            this._cfgEmptyStringAsNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
            this._cfgEmptyUnquotedStringAsNull = Feature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(this._formatFeatures);
        }
        return this;
    }

    public JsonParser enable(Feature f) {
        this._formatFeatures |= f.getMask();
        this._cfgEmptyStringAsNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        this._cfgEmptyUnquotedStringAsNull = Feature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        this._cfgEmptyStringAsNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        this._cfgEmptyUnquotedStringAsNull = Feature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    @Override
    public CsvSchema getSchema() {
        return this._schema;
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public JsonLocation currentLocation() {
        return this._reader.getCurrentLocation();
    }

    @Override
    public JsonLocation currentTokenLocation() {
        return this._reader.getTokenLocation();
    }

    @Override
    @Deprecated
    public JsonLocation getCurrentLocation() {
        return this.currentLocation();
    }

    @Override
    @Deprecated
    public JsonLocation getTokenLocation() {
        return this.currentTokenLocation();
    }

    @Override
    public Object getInputSource() {
        return this._reader.getInputSource();
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        if (this._currToken == null) {
            return false;
        }
        switch (this._currToken.id()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        try {
            if (this._columnIndex < this._columnCount) {
                CsvSchema.Column column = this._schema.column(this._columnIndex);
                if (column.getType() == CsvSchema.ColumnType.STRING) {
                    this._startArray(column);
                    return true;
                }
            } else if (this._currToken == JsonToken.VALUE_STRING) {
                this._startArray(CsvSchema.Column.PLACEHOLDER);
                return true;
            }
        }
        catch (StreamConstraintsException e) {
            throw new UncheckedIOException(e);
        }
        return false;
    }

    @Override
    public boolean isExpectedNumberIntToken() {
        JsonToken t2 = this._currToken;
        if (t2 == JsonToken.VALUE_STRING) {
            try {
                if (this._reader.isExpectedNumberIntToken()) {
                    this._updateToken(JsonToken.VALUE_NUMBER_INT);
                    return true;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return false;
        }
        return t2 == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public String currentName() throws IOException {
        return this._currentName;
    }

    @Override
    public void overrideCurrentName(String name) {
        this._currentName = name;
    }

    @Override
    @Deprecated
    public String getCurrentName() throws IOException {
        return this.currentName();
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                return this._updateToken(this._handleStartDoc());
            }
            case 1: {
                return this._updateToken(this._handleRecordStart());
            }
            case 2: {
                return this._updateToken(this._handleNextEntry());
            }
            case 3: {
                return this._updateToken(this._handleNamedValue());
            }
            case 4: {
                return this._updateToken(this._handleUnnamedValue());
            }
            case 5: {
                return this._updateToken(this._handleArrayValue());
            }
            case 6: {
                return this._skipUntilEndOfLine();
            }
            case 7: {
                return this._updateToken(this._handleMissingName());
            }
            case 8: {
                return this._updateToken(this._handleMissingValue());
            }
            case 9: {
                this._reader.close();
                if (this._parsingContext.inRoot()) {
                    return null;
                }
                boolean inArray = this._parsingContext.inArray();
                this._parsingContext = this._parsingContext.getParent();
                return inArray ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean nextFieldName(SerializableString str) throws IOException {
        if (this._state == 2) {
            this._binaryValue = null;
            JsonToken t2 = this._updateToken(this._handleNextEntry());
            if (t2 == JsonToken.FIELD_NAME) {
                return str.getValue().equals(this._currentName);
            }
            return false;
        }
        return this.nextToken() == JsonToken.FIELD_NAME && str.getValue().equals(this.getCurrentName());
    }

    @Override
    public String nextFieldName() throws IOException {
        if (this._state == 2) {
            this._binaryValue = null;
            JsonToken t2 = this._updateToken(this._handleNextEntry());
            if (t2 == JsonToken.FIELD_NAME) {
                return this._currentName;
            }
            return null;
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    @Override
    public String nextTextValue() throws IOException {
        this._binaryValue = null;
        if (this._state == 3) {
            JsonToken t2 = this._updateToken(this._handleNamedValue());
            if (t2 == JsonToken.VALUE_STRING) {
                return this._currentValue;
            }
        } else if (this._state == 4) {
            JsonToken t3 = this._updateToken(this._handleUnnamedValue());
            if (t3 == JsonToken.VALUE_STRING) {
                return this._currentValue;
            }
        } else {
            JsonToken t4 = this.nextToken();
            if (t4 == JsonToken.VALUE_STRING) {
                return this.getText();
            }
        }
        return null;
    }

    protected void _readHeaderLine() throws IOException {
        int diff;
        CsvSchema newSchema;
        int newColumnCount;
        String name;
        int schemaColumnCount = this._schema.size();
        if (schemaColumnCount > 0 && !this._schema.reordersColumns()) {
            if (this._schema.strictHeaders()) {
                String name2;
                int ix = 0;
                for (CsvSchema.Column column : this._schema._columns) {
                    name2 = this._reader.nextString();
                    ++ix;
                    if (name2 == null) {
                        this._reportError(String.format("Missing header column #%d, expecting \"%s\"", ix, column.getName()));
                        continue;
                    }
                    if (column.getName().equals(name2)) continue;
                    this._reportError(String.format("Mismatched header column #%d: expected \"%s\", actual \"%s\"", ix, column.getName(), name2));
                }
                name2 = this._reader.nextString();
                if (name2 != null) {
                    this._reportError(String.format("Extra header column \"%s\"", name2));
                }
            } else {
                int allowed = 99999;
                while (this._reader.nextString() != null) {
                    if (--allowed >= 0) continue;
                    this._reportError("Internal error: skipped 99999 header columns");
                }
            }
            return;
        }
        CsvSchema.Builder builder = this._schema.rebuild().clearColumns();
        int count = 0;
        while ((name = this._reader.nextString()) != null) {
            CsvSchema.Column prev = this._schema.column(name = name.trim());
            if (prev != null) {
                builder.addColumn(name, prev.getType());
            } else {
                builder.addColumn(name);
            }
            if (++count <= 99999) continue;
            this._reportError("Internal error: reached maximum of 99999 header columns");
        }
        if (Feature.ALLOW_TRAILING_COMMA.enabledIn(this._formatFeatures)) {
            builder.dropLastColumnIfEmpty();
        }
        if ((newColumnCount = (newSchema = builder.build()).size()) < 2) {
            String first;
            String string = first = newColumnCount == 0 ? "" : newSchema.columnName(0).trim();
            if (first.isEmpty()) {
                this._reportCsvMappingError("Empty header line: can not bind data", new Object[0]);
            }
        }
        if ((diff = schemaColumnCount - newColumnCount) > 0 && Feature.FAIL_ON_MISSING_HEADER_COLUMNS.enabledIn(this._formatFeatures)) {
            LinkedHashSet<String> oldColumnNames = new LinkedHashSet<String>();
            this._schema.getColumnNames(oldColumnNames);
            oldColumnNames.removeAll(newSchema.getColumnNames());
            this._reportCsvMappingError(String.format("Missing %d header column%s: [\"%s\"]", diff, diff == 1 ? "" : "s", String.join((CharSequence)"\",\"", oldColumnNames)), new Object[0]);
        }
        this.setSchema(builder.build());
    }

    protected JsonToken _handleStartDoc() throws IOException {
        this._reader.skipLinesWhenNeeded();
        if (this._schema.usesHeader()) {
            this._readHeaderLine();
            this._reader.skipLinesWhenNeeded();
        }
        if (this._schema.skipsFirstDataRow()) {
            this._reader.skipLine();
            this._reader.skipLinesWhenNeeded();
        }
        boolean wrapAsArray = Feature.WRAP_AS_ARRAY.enabledIn(this._formatFeatures);
        if (!this._reader.hasMoreInput()) {
            this._state = 9;
            if (wrapAsArray) {
                this._parsingContext = this._reader.childArrayContext(this._parsingContext);
                return JsonToken.START_ARRAY;
            }
            return null;
        }
        if (wrapAsArray) {
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            this._state = 1;
            return JsonToken.START_ARRAY;
        }
        return this._handleRecordStart();
    }

    protected JsonToken _handleRecordStart() throws IOException {
        this._columnIndex = 0;
        if (this._columnCount == 0) {
            this._state = 4;
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            return JsonToken.START_ARRAY;
        }
        this._parsingContext = this._reader.childObjectContext(this._parsingContext);
        this._state = 2;
        return JsonToken.START_OBJECT;
    }

    protected JsonToken _handleNextEntry() throws IOException {
        String next;
        try {
            next = this._reader.nextString();
        }
        catch (IOException e) {
            this._state = 6;
            throw e;
        }
        if (next == null) {
            if (this._columnIndex < this._columnCount) {
                return this._handleMissingColumns();
            }
            return this._handleObjectRowEnd();
        }
        if (this._columnIndex >= this._columnCount) {
            this._currentValue = next;
            return this._handleExtraColumn(next);
        }
        CsvSchema.Column column = this._schema.column(this._columnIndex);
        this._state = 3;
        this._currentName = column.getName();
        CsvValueDecorator dec = column.getValueDecorator();
        this._currentValue = dec == null ? next : dec.undecorateValue(this, next);
        return JsonToken.FIELD_NAME;
    }

    protected JsonToken _handleNamedValue() throws IOException {
        if (this._columnIndex < this._columnCount) {
            CsvSchema.Column column = this._schema.column(this._columnIndex);
            ++this._columnIndex;
            if (column.isArray()) {
                this._startArray(column);
                return JsonToken.START_ARRAY;
            }
        }
        this._state = 2;
        if (this._isNullValue(this._currentValue)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleUnnamedValue() throws IOException {
        String next = this._reader.nextString();
        if (next == null) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = !this._reader.startNewLine() ? 9 : 1;
            return JsonToken.END_ARRAY;
        }
        this._currentValue = next;
        ++this._columnIndex;
        if (this._isNullValue(next)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleArrayValue() throws IOException {
        int offset = this._arrayValueStart;
        if (offset < 0) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = 2;
            return JsonToken.END_ARRAY;
        }
        int end = this._arrayValue.indexOf(this._arraySeparator, offset);
        if (end < 0) {
            this._arrayValueStart = end;
            if (offset == 0) {
                if (this._arrayValue.isEmpty() || this._arrayValue.trim().isEmpty()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._state = 2;
                    return JsonToken.END_ARRAY;
                }
                this._currentValue = this._arrayValue;
            } else {
                this._currentValue = this._arrayValue.substring(offset);
            }
        } else {
            this._currentValue = this._arrayValue.substring(offset, end);
            this._arrayValueStart = end + this._arraySeparator.length();
        }
        if (this.isEnabled(Feature.TRIM_SPACES)) {
            this._currentValue = this._currentValue.trim();
        }
        if (this._isNullValue(this._currentValue)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleExtraColumn(String value) throws IOException {
        String next;
        String anyProp = this._schema.getAnyPropertyName();
        if (anyProp != null) {
            this._currentName = anyProp;
            this._state = 3;
            return JsonToken.FIELD_NAME;
        }
        this._currentName = null;
        if (Feature.IGNORE_TRAILING_UNMAPPABLE.enabledIn(this._formatFeatures)) {
            this._state = 6;
            return this._skipUntilEndOfLine();
        }
        this._state = 6;
        if (this._columnIndex == this._columnCount && Feature.ALLOW_TRAILING_COMMA.enabledIn(this._formatFeatures) && (value = value.trim()).isEmpty() && (next = this._reader.nextString()) == null) {
            return this._handleObjectRowEnd();
        }
        return (JsonToken)((Object)this._reportCsvMappingError("Too many entries: expected at most %d (value #%d (%d chars) \"%s\")", this._columnCount, this._columnIndex, value.length(), value));
    }

    protected JsonToken _handleMissingColumns() throws IOException {
        if (Feature.FAIL_ON_MISSING_COLUMNS.enabledIn(this._formatFeatures)) {
            this._handleObjectRowEnd();
            return (JsonToken)((Object)this._reportCsvMappingError("Not enough column values: expected %d, found %d", this._columnCount, this._columnIndex));
        }
        if (Feature.INSERT_NULLS_FOR_MISSING_COLUMNS.enabledIn(this._formatFeatures)) {
            this._state = 8;
            this._currentName = this._schema.columnName(this._columnIndex);
            this._currentValue = null;
            return JsonToken.FIELD_NAME;
        }
        return this._handleObjectRowEnd();
    }

    protected JsonToken _handleMissingName() throws IOException {
        if (++this._columnIndex < this._columnCount) {
            this._state = 8;
            this._currentName = this._schema.columnName(this._columnIndex);
            return JsonToken.FIELD_NAME;
        }
        return this._handleObjectRowEnd();
    }

    protected JsonToken _handleMissingValue() throws IOException {
        this._state = 7;
        return JsonToken.VALUE_NULL;
    }

    protected final JsonToken _handleObjectRowEnd() throws IOException {
        this._parsingContext = this._parsingContext.getParent();
        this._state = !this._reader.startNewLine() ? 9 : 1;
        return JsonToken.END_OBJECT;
    }

    protected final JsonToken _skipUntilEndOfLine() throws IOException {
        while (this._reader.nextString() != null) {
        }
        this._parsingContext = this._parsingContext.getParent();
        this._state = this._reader.startNewLine() ? 1 : 9;
        return this._updateToken(this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return false;
        }
        return this._textBuffer.hasTextAsCharacters();
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentName;
        }
        return this._currentValue;
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentName.toCharArray();
        }
        return this._textBuffer.contentsAsArray();
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentName.length();
        }
        return this._textBuffer.size();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public int getText(Writer w) throws IOException {
        String value;
        String string = value = this._currToken == JsonToken.FIELD_NAME ? this._currentName : this._currentValue;
        if (value == null) {
            return 0;
        }
        w.write(value);
        return value.length();
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        return this._binaryValue;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant variant) throws IOException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportCsvMappingError("Current token (%s) not VALUE_STRING, can not access as binary", new Object[]{this._currToken});
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this._currentValue, builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        return this._reader.getNumberType();
    }

    @Override
    public JsonParser.NumberTypeFP getNumberTypeFP() throws IOException {
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this._reader.getNumberValue(false);
    }

    @Override
    public Number getNumberValueExact() throws IOException {
        return this._reader.getNumberValue(true);
    }

    @Override
    public int getIntValue() throws IOException {
        return this._reader.getIntValue();
    }

    @Override
    public long getLongValue() throws IOException {
        return this._reader.getLongValue();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this._reader.getBigIntegerValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return this._reader.getFloatValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this._reader.getDoubleValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this._reader.getDecimalValue();
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF(": expected closing quote character", null);
    }

    public <T> T _reportCsvMappingError(String msg, Object ... args) throws IOException {
        if (args.length > 0) {
            msg = String.format(msg, args);
        }
        throw CsvReadException.from(this, msg, this._schema);
    }

    public void _reportParsingError(String msg) throws JsonProcessingException {
        super._reportError(msg);
    }

    public void _reportUnexpectedCsvChar(int ch, String msg) throws JsonProcessingException {
        super._reportUnexpectedChar(ch, msg);
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _startArray(CsvSchema.Column column) throws StreamConstraintsException {
        this._updateToken(JsonToken.START_ARRAY);
        this._parsingContext = this._parsingContext.createChildArrayContext(this._reader.getCurrentRow(), this._reader.getCurrentColumn());
        this._state = 5;
        this._arrayValueStart = 0;
        this._arrayValue = this._currentValue;
        String sep = column.getArrayElementSeparator();
        if (sep.isEmpty()) {
            sep = this._schema.getArrayElementSeparator();
        }
        this._arraySeparator = sep;
    }

    protected boolean _isNullValue(String value) {
        if (this._nullValue != null && this._nullValue.equals(value)) {
            return true;
        }
        if (this._cfgEmptyStringAsNull && value.isEmpty()) {
            return true;
        }
        return this._cfgEmptyUnquotedStringAsNull && value.isEmpty() && !this._reader.isCurrentTokenQuoted();
    }

    public static enum Feature implements FormatFeature
    {
        TRIM_SPACES(false),
        WRAP_AS_ARRAY(false),
        IGNORE_TRAILING_UNMAPPABLE(false),
        SKIP_EMPTY_LINES(false),
        ALLOW_TRAILING_COMMA(true),
        ALLOW_COMMENTS(false),
        FAIL_ON_MISSING_COLUMNS(false),
        FAIL_ON_MISSING_HEADER_COLUMNS(true),
        INSERT_NULLS_FOR_MISSING_COLUMNS(false),
        EMPTY_STRING_AS_NULL(false),
        EMPTY_UNQUOTED_STRING_AS_NULL(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        @Override
        public int getMask() {
            return this._mask;
        }
    }
}

