/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.contract;

import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.server.DefaultServerFactory;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiContractBundle
implements ConfiguredBundle<Configuration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiContractBundle.class);
    public static final OpenApiCustomizer DEFAULT_LOCAL_SERVER_CUSTOMIZER = (configuration, environment, oas) -> {
        DefaultServerFactory serverFactory = (DefaultServerFactory)configuration.getServerFactory();
        StringBuilder serverUrl = new StringBuilder();
        Optional.ofNullable(serverFactory.getApplicationContextPath()).ifPresent(serverUrl::append);
        serverFactory.getJerseyRootPath().ifPresent(serverUrl::append);
        String endpointPath = URIUtil.compactPath(serverUrl.toString());
        oas.addServersItem(new Server().url(StringUtils.defaultIfEmpty(StringUtils.removeEnd(endpointPath, "/"), "/")));
    };
    private final List<Package> resourcePackages;
    private final List<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>();

    public OpenApiContractBundle(List<Package> resourcePackages, List<OpenApiCustomizer> customizers) {
        this.resourcePackages = resourcePackages;
        this.customizers.addAll(customizers);
    }

    @Override
    public void run(Configuration configuration, Environment environment) {
        OpenAPI oas = new OpenAPI();
        this.customizers.forEach(c -> c.accept(configuration, environment, oas));
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().openAPI(oas).prettyPrint(true).resourcePackages(this.resourcePackages.stream().map(Package::getName).collect(Collectors.toSet()));
        LOGGER.info("Registering OpenAPI resource");
        environment.jersey().register(new OpenApiResource().openApiConfiguration(oasConfig));
    }
}

