/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.rules;

import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextCapture {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextCapture.class);
    public static final String OUTPUT_DIR_PROPERTY = "debugOutput";
    public static final String LEVEL_PROPERTY = "debugLevel";
    public static final String PROVIDER_NUMBER_HEADER = "Provider #:";
    public static final String SCENARIO_NUMBER_HEADER = "Scenario #:";
    public static final String REQUEST_IDENTIFIER_HEADER = "Request Identifier:";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmssSSS");
    private static final AtomicInteger SEQUENCE_GENERATOR = new AtomicInteger(1);
    private static final File OUTPUT_DIRECTORY;
    private static final File AGGREGATE_REPORT;
    private static final AtomicInteger SCENARIO_COUNTER;
    private static final Pattern PROVIDER_PATTERN;
    private static final Pattern REQUEST_IDENTIFIER_PATTERN;
    private static final String HEADER_FORMAT = "%1$-20s%2$32s";

    public static void resetRuleSequence() {
        SEQUENCE_GENERATOR.set(1);
    }

    public static void captureRule(CalculationContext<?, ?> calculationContext, Class<? extends CalculationRule> ruleClass) {
        if (DebugContent.RULE.equals((Object)DebugContent.fromSystemProperties())) {
            ContextCapture.captureContext(SEQUENCE_GENERATOR.getAndIncrement() + "_" + ruleClass.getSimpleName(), calculationContext);
        }
    }

    public static void captureClaim(CalculationContext<?, ?> calculationContext, Class<? extends ClaimProcessor> pricerClass) {
        if (EnumSet.of(DebugContent.AGGREGATE, DebugContent.CLAIM).contains((Object)DebugContent.fromSystemProperties())) {
            ContextCapture.captureContext(pricerClass.getSimpleName(), calculationContext);
        }
    }

    public static File getOutputDirectory() {
        return OUTPUT_DIRECTORY;
    }

    private static void captureContext(String referenceName, CalculationContext<?, ?> calculationContext) {
        if (!OUTPUT_DIRECTORY.exists()) {
            LOGGER.info("Output directory created: {}", (Object)OUTPUT_DIRECTORY.mkdirs());
        }
        if (DebugContent.AGGREGATE.equals((Object)DebugContent.fromSystemProperties())) {
            ContextCapture.outputContext(AGGREGATE_REPORT, true, calculationContext);
        } else {
            ContextCapture.outputContext(ContextCapture.getOutputFile(referenceName), false, calculationContext);
        }
    }

    private static void outputContext(File destinationFile, boolean shouldAppend, CalculationContext<?, ?> calculationContext) {
        try (FileWriter fileWriter = new FileWriter(destinationFile, shouldAppend);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            String serializedContent = calculationContext.serializeContent();
            if (shouldAppend) {
                Matcher identifierMatcher;
                if (1 < SCENARIO_COUNTER.get()) {
                    printWriter.println();
                }
                printWriter.println(StringUtils.repeat('=', 80));
                printWriter.println(String.format(HEADER_FORMAT, SCENARIO_NUMBER_HEADER, SCENARIO_COUNTER.getAndIncrement()));
                Matcher providerMatcher = PROVIDER_PATTERN.matcher(serializedContent);
                if (providerMatcher.find()) {
                    printWriter.println(String.format(HEADER_FORMAT, PROVIDER_NUMBER_HEADER, providerMatcher.group(1)));
                }
                if ((identifierMatcher = REQUEST_IDENTIFIER_PATTERN.matcher(serializedContent)).find()) {
                    printWriter.println(String.format(HEADER_FORMAT, REQUEST_IDENTIFIER_HEADER, identifierMatcher.group(1)));
                }
                printWriter.println(StringUtils.repeat('-', 80));
            }
            printWriter.println(serializedContent);
            printWriter.flush();
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to capture context", ioe);
        }
    }

    private static File getOutputFile(String referenceName) {
        return ContextCapture.getOutputFile(referenceName, ".json");
    }

    private static File getOutputFile(String referenceName, String extension) {
        return new File(OUTPUT_DIRECTORY, TIMESTAMP_FORMATTER.format(LocalDateTime.now()) + "_" + referenceName + extension);
    }

    @Generated
    private ContextCapture() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SCENARIO_COUNTER = new AtomicInteger(1);
        PROVIDER_PATTERN = Pattern.compile("\"providerNumber\" : \"(\\d{6})\"");
        REQUEST_IDENTIFIER_PATTERN = Pattern.compile("\"requestIdentifier\" : \"([^\"]+)\"");
        OUTPUT_DIRECTORY = new File(System.getProperty(OUTPUT_DIR_PROPERTY, System.getProperty("user.dir") + "/target/reports/debug"));
        AGGREGATE_REPORT = ContextCapture.getOutputFile("aggregate", ".txt");
    }

    public static enum DebugContent {
        NONE,
        AGGREGATE,
        CLAIM,
        RULE;


        static DebugContent fromSystemProperties() {
            String level = StringUtils.upperCase(System.getProperty(ContextCapture.LEVEL_PROPERTY, NONE.name()));
            return Arrays.stream(DebugContent.values()).filter(e -> e.name().equals(level)).findFirst().orElse(NONE);
        }
    }
}

