/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.csv;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.api.serialization.BasicIsoDateModule;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.CsvIngestionException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvContentReader<C> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvContentReader.class);
    public static final UnaryOperator<CsvSchema> HEADER_ROW_CUSTOMIZER = CsvSchema::withHeader;
    private static final CsvMapper DEFAULT_CSV_MAPPER = (CsvMapper)new CsvMapper().enable(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE).enable(CsvParser.Feature.FAIL_ON_MISSING_COLUMNS).enable(CsvParser.Feature.SKIP_EMPTY_LINES).findAndRegisterModules().registerModule(new BasicIsoDateModule()).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
    private final Class<C> typeClass;
    private final BiFunction<Class<C>, CsvMapper, CsvSchema> defaultSchemaProvider = (type, mapper) -> mapper.typedSchemaFor((Class<?>)type);
    private Function<CsvMapper, CsvMapper> mapperCustomizer = UnaryOperator.identity();
    private Function<CsvSchema, CsvSchema> schemaCustomizer = UnaryOperator.identity();
    private boolean emptyContentIgnored = false;
    private boolean validationEnabled = true;
    private CsvMapper csvMapper = DEFAULT_CSV_MAPPER;
    private CsvSchema csvSchema;

    public CsvContentReader(Class<C> typeClass) {
        this.typeClass = typeClass;
    }

    public CsvContentReader<C> applyConfiguration(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.disableValidation();
        }
        if (csvIngestionConfiguration.isIgnoreEmpty()) {
            this.ignoreEmptyContent();
        }
        return this;
    }

    public CsvContentReader<C> customizeMapper(Function<CsvMapper, CsvMapper> mapperCustomizer) {
        this.mapperCustomizer = mapperCustomizer;
        return this;
    }

    public CsvContentReader<C> customizeMapper(UnaryOperator<CsvMapper> mapperCustomizer) {
        return this.customizeMapper((Function<CsvMapper, CsvMapper>)mapperCustomizer);
    }

    public CsvContentReader<C> customizeSchema(Function<CsvSchema, CsvSchema> schemaCustomizer) {
        this.schemaCustomizer = schemaCustomizer;
        return this;
    }

    public CsvContentReader<C> customizeSchema(UnaryOperator<CsvSchema> schemaCustomizer) {
        return this.customizeSchema((Function<CsvSchema, CsvSchema>)schemaCustomizer);
    }

    public CsvContentReader<C> withMapper(CsvMapper csvMapper) {
        this.csvMapper = csvMapper;
        return this;
    }

    public CsvContentReader<C> withSchema(CsvSchema csvSchema) {
        this.csvSchema = csvSchema;
        return this;
    }

    public CsvContentReader<C> disableValidation() {
        this.validationEnabled = false;
        return this;
    }

    public CsvContentReader<C> ignoreEmptyContent() {
        this.emptyContentIgnored = true;
        return this;
    }

    public List<C> read(String csvFilename) {
        if (null == csvFilename) {
            return new ArrayList();
        }
        InputStream csvSource = CsvContentReader.class.getResourceAsStream(csvFilename);
        return this.read(csvSource);
    }

    public List<C> read(InputStream csvSource) {
        if (null == csvSource) {
            return new ArrayList();
        }
        return this.read(new InputStreamReader(new BOMInputStream(csvSource)));
    }

    public List<C> read(Reader csvSource) {
        CsvMapper readMapper = this.mapperCustomizer.apply(this.csvMapper);
        CsvSchema readSchema = this.schemaCustomizer.apply(Optional.ofNullable(this.csvSchema).orElse(this.defaultSchemaProvider.apply(this.typeClass, readMapper)));
        try {
            MappingIterator iter = readMapper.readerFor(this.typeClass).with(readSchema).readValues(csvSource);
            if (!this.emptyContentIgnored && !iter.hasNext()) {
                throw new CsvIngestionException("The CSV did not contain any content.");
            }
            List csvContent = iter.readAll();
            if (this.validationEnabled) {
                this.validate(csvContent);
            }
            return csvContent;
        }
        catch (ConstraintViolationException | IOException e) {
            throw new CsvIngestionException(e);
        }
    }

    private void validate(List<C> csvContent) {
        Set<ConstraintViolation<C>> violations = csvContent.stream().map(this::validate).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!violations.isEmpty()) {
            this.logViolations(violations);
            throw new ConstraintViolationException(violations);
        }
    }

    private Set<ConstraintViolation<C>> validate(C content) {
        return VALIDATOR.validate(content, new Class[0]);
    }

    private void logViolations(Set<ConstraintViolation<C>> violations) {
        String violationMessage = violations.stream().map(cv -> String.format("%s: %s, provided value was '%s'", cv.getPropertyPath(), cv.getMessage(), cv.getInvalidValue())).collect(Collectors.joining("\\n"));
        LOGGER.error("Failed to read CSV content: {}", (Object)violationMessage);
    }
}

