/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core;

import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Ipps2026PricerContext
extends IppsPricerContext {
    public static final String CALCULATION_VERSION = "2026.0";
    private static final BigDecimal CAPITAL_BASE_RATE_2026 = new BigDecimal("524.15");
    private static final BigDecimal OPERATING_BASE_RATE_2026 = new BigDecimal("6752.61");
    private static final BigDecimal MIDNIGHT_ADJUSTMENT_FACTOR_2026 = new BigDecimal("1.0");
    private static final BigDecimal COST_THRESHOLD_BASE_2026 = new BigDecimal("40397.00");
    private static final BigDecimal LABOR_PCT_WI_GT_ONE_2026 = new BigDecimal("0.66");
    private static final BigDecimal NON_LABOR_PCT_WI_GT_ONE_2026 = new BigDecimal("0.34");
    private static final BigDecimal LABOR_PCT_WI_LTEQ_ONE_2026 = new BigDecimal("0.62");
    private static final BigDecimal NON_LABOR_PCT_WI_LTEQ_ONE_2026 = new BigDecimal("0.38");
    private static final BigDecimal NO_COST_PRODUCT_ADJUSTMENT_FACTOR_2026 = new BigDecimal("0.16");
    private static final BigDecimal MARKET_BASKET_RATIO_EHR_FULL_2026 = new BigDecimal("1.024719101");
    private static final BigDecimal MARKET_BASKET_RATIO_EHR_QUALIFIED_FULL_2026 = new BigDecimal("1.024924471");
    private static final BigDecimal MARKET_BASKET_RATIO_EHR_FULL_PR_2026 = new BigDecimal("1.024719101");
    private static final BigDecimal OPER_HSP_BUDGET_NEUTRAL_BASE_2026_1 = new BigDecimal("0.998580").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_BUDGET_NEUTRAL_BASE_2026_2 = new BigDecimal("0.999897").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_UPDATE_NO_QUALITY_EHR_2026 = new BigDecimal("0.9930").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_UPDATE_NO_QUALITY_NO_EHR_2026 = new BigDecimal("1.01775").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_UPDATE_QUALITY_EHR_2026 = new BigDecimal("1.00125").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_UPDATE_QUALITY_NO_EHR_2026 = new BigDecimal("1.0260").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_UPDATE_NO_EHR_PR_2026 = new BigDecimal("1.0260").setScale(6, RoundingMode.HALF_UP);
    private static final BigDecimal OPER_HSP_UPDATE_EHR_PR_2026 = new BigDecimal("1.00125").setScale(6, RoundingMode.HALF_UP);

    public Ipps2026PricerContext(IppsClaimPricingRequest input, IppsClaimPricingResponse output, DataTables dataTables) {
        super(input, output, dataTables);
    }

    @Override
    public BigDecimal getBudgetNeutralBase() {
        return OPER_HSP_BUDGET_NEUTRAL_BASE_2026_1.multiply(OPER_HSP_BUDGET_NEUTRAL_BASE_2026_2);
    }

    @Override
    public String getCalculationVersion() {
        return CALCULATION_VERSION;
    }

    @Override
    public BigDecimal getMidnightAdjustmentFactor() {
        return MIDNIGHT_ADJUSTMENT_FACTOR_2026;
    }

    @Override
    public BigDecimal getNoCostProductAdjustmentFactorValue() {
        return NO_COST_PRODUCT_ADJUSTMENT_FACTOR_2026;
    }

    @Override
    public BigDecimal getCapitalBaseRate() {
        return CAPITAL_BASE_RATE_2026;
    }

    @Override
    public BigDecimal getCostThresholdBase() {
        return COST_THRESHOLD_BASE_2026;
    }

    @Override
    public BigDecimal getNationalLaborPctWageIndexGtOne() {
        return LABOR_PCT_WI_GT_ONE_2026;
    }

    @Override
    public BigDecimal getNationalNonLaborPctWageIndexGtOne() {
        return NON_LABOR_PCT_WI_GT_ONE_2026;
    }

    @Override
    public BigDecimal getNationalLaborPctWageIndexLtEqOne() {
        return LABOR_PCT_WI_LTEQ_ONE_2026;
    }

    @Override
    public BigDecimal getNationalNonLaborPctWageIndexLtEqOne() {
        return NON_LABOR_PCT_WI_LTEQ_ONE_2026;
    }

    @Override
    public BigDecimal getHospitalSpecificPortionUpdateFactorWithQualityAndNoEhrReduction() {
        return OPER_HSP_UPDATE_QUALITY_NO_EHR_2026;
    }

    @Override
    public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoQualityAndNoEhrReduction() {
        return OPER_HSP_UPDATE_NO_QUALITY_NO_EHR_2026;
    }

    @Override
    public BigDecimal getHospitalSpecificPortionUpdateFactorWithQualityAndEhrReduction() {
        return OPER_HSP_UPDATE_QUALITY_EHR_2026;
    }

    @Override
    public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoQualityAndEhrReduction() {
        return OPER_HSP_UPDATE_NO_QUALITY_EHR_2026;
    }

    @Override
    public BigDecimal getHospitalSpecificPortionUpdateFactorWithNoEhrReductionPuertoRico() {
        return OPER_HSP_UPDATE_NO_EHR_PR_2026;
    }

    @Override
    public BigDecimal getHospitalSpecificPortionUpdateFactorWithEhrReductionPuertoRico() {
        return OPER_HSP_UPDATE_EHR_PR_2026;
    }

    @Override
    public BigDecimal getMarketBasketRatioEhrFull() {
        return MARKET_BASKET_RATIO_EHR_FULL_2026;
    }

    @Override
    public BigDecimal getMarketBasketRatioEhrQualifiedFull() {
        return MARKET_BASKET_RATIO_EHR_QUALIFIED_FULL_2026;
    }

    @Override
    public BigDecimal getMarketBasketRatioEhrFullPuertoRico() {
        return MARKET_BASKET_RATIO_EHR_FULL_PR_2026;
    }

    @Override
    public BigDecimal getOperatingBaseRate() {
        return OPERATING_BASE_RATE_2026;
    }
}

