/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DefaultOutlierPricing
extends EvaluatingCalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    public DefaultOutlierPricing(List<CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext>> calculationRules) {
        super(calculationRules);
    }

    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return ArrayUtils.contains((Object[])new ResultCode[]{ResultCode.RC_00_OK, ResultCode.RC_03_TRANSFER_PAID_PERDIEM_DAYS, ResultCode.RC_10_POST_ACUTE_XFER, ResultCode.RC_12_POST_ACUTE_XFER_WITH_DRGS, ResultCode.RC_14_PAID_DRG_WITH_PERDIEM}, (Object)calculationContext.getResultCode());
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        calculationContext.setOutlierReconciliation(true);
        calculationContext.clearContextState();
        IppsClaimPricingResponse output = (IppsClaimPricingResponse)calculationContext.getOutput();
        IppsPaymentData holdPayment = (IppsPaymentData)output.getPaymentData();
        ReturnCodeData holdReturnCode = output.getReturnCodeData();
        ReturnCodeData returnCode = new ReturnCodeData();
        returnCode.setCode("00");
        returnCode.setDescription("No description available.");
        output.setReturnCodeData(returnCode);
        output.setPaymentData(new IppsPaymentData());
        super.calculate(calculationContext);
        output.setPaymentData(holdPayment);
        output.setReturnCodeData(holdReturnCode);
        calculationContext.setOutlierReconciliation(false);
        if (calculationContext.isOutlierAdjustmentEnabled()) {
            calculationContext.adjustResultCodeForOutliers();
        }
    }
}

