/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateCapitalCosts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsClaimData claimData = calculationContext.getClaimData();
        BigDecimal capitalBillCosts = claimData.getCoveredCharges().multiply(calculationContext.getCapitalOperatingCostToChargeRatio()).setScale(9, RoundingMode.HALF_UP);
        if (BigDecimalUtils.isGreaterThan(capitalBillCosts, calculationContext.getCapitalCostOutlier())) {
            calculationContext.setCapitalOutlierCostPart(capitalBillCosts.subtract(calculationContext.getCapitalCostOutlier()).multiply(calculationContext.getCostOutlierPct()).setScale(9, RoundingMode.HALF_UP));
        }
        if (StringUtils.equals(calculationContext.getProviderData().getCapitalPpsPaymentCode(), "C")) {
            calculationContext.setCapitalOutlierCostPart(calculationContext.getCapitalOutlierCostPart().multiply(calculationContext.getCapitalPaycodePct1()).setScale(9, RoundingMode.HALF_UP));
        }
        if (BigDecimalUtils.isLessThan(capitalBillCosts.add(calculationContext.getOperatingBillCosts()), calculationContext.getCapitalCostOutlier().add(calculationContext.getOperatingCostOutlier()))) {
            calculationContext.setCapitalOutlierCostPart(BigDecimal.ZERO);
            calculationContext.setOperatingOutlierCostPart(BigDecimal.ZERO);
        }
        if (calculationContext.isPayWithoutCost() || calculationContext.isPayTransferNoCost() || calculationContext.isPayTransferSpecialDrugNoCost()) {
            calculationContext.setCapitalOutlierCostPart(BigDecimal.ZERO);
        }
    }
}

