/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateCapitalDisproportionateShareHospital
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equalsAny(cbsaReference.getSize(), "O", "L") && providerData.getBedSize() > 99) {
            calculationContext.setCapitalDisproportionateShareHospital(BigDecimalUtils.pow(new BigDecimal("2.7183"), new BigDecimal("0.2025").multiply(providerData.getSupplementalSecurityIncomeRatio().add(providerData.getMedicaidRatio())), 5).subtract(BigDecimal.ONE).setScale(4, RoundingMode.HALF_UP));
        }
    }
}

