/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateCapitalPaymentMethodB
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        calculationContext.setCapitalGeographicAdjFactor(BigDecimalUtils.pow(cbsaReference.getWageIndex(), new BigDecimal("0.6848"), 100).setScale(4, RoundingMode.HALF_UP));
        BigDecimal federalRate = calculationContext.getCapitalBaseRate().multiply(calculationContext.getCapitalGeographicAdjFactor()).setScale(2, RoundingMode.HALF_UP);
        calculationContext.setCapitalCostOfLivingAdjustment(new BigDecimal("0.3152").multiply(calculationContext.getOperatingCostOfLivingAdjustment().subtract(BigDecimal.ONE)).add(BigDecimal.ONE).setScale(3, RoundingMode.HALF_UP));
        calculationContext.setCapitalFederalRate(federalRate);
    }
}

