/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateOperatingCosts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsClaimData claimData = calculationContext.getClaimData();
        calculationContext.setOperatingBillCosts(claimData.getCoveredCharges().multiply(calculationContext.getOperatingCostToChargeRatio()).setScale(9, RoundingMode.HALF_UP));
        if (BigDecimalUtils.isGreaterThan(calculationContext.getOperatingBillCosts(), calculationContext.getOperatingCostOutlier())) {
            calculationContext.setOperatingOutlierCostPart(calculationContext.getOperatingBillCosts().subtract(calculationContext.getOperatingCostOutlier()).multiply(calculationContext.getCostOutlierPct()).setScale(9, RoundingMode.HALF_UP));
        }
        if (calculationContext.isPayWithoutCost() || calculationContext.isPayTransferNoCost() || calculationContext.isPayTransferSpecialDrugNoCost()) {
            calculationContext.setOperatingOutlierCostPart(BigDecimal.ZERO);
        }
    }
}

