/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class InitializeCalculationFields
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        calculationContext.applyResultCode(ResultCode.RC_00_OK);
        paymentData.setFinalWageIndex(calculationContext.getCbsaReference().getWageIndex());
        paymentData.setAverageLengthOfStay(calculationContext.getDrgsTableEntry().getGeometricMeanLengthOfStay());
        paymentData.setDaysCutoff(BigDecimal.ZERO.setScale(1, RoundingMode.UNNECESSARY));
        BigDecimal perdiemDays = BigDecimal.valueOf(calculationContext.getClaimData().getLengthOfStay().intValue());
        if (BigDecimalUtils.isLessThan(perdiemDays, BigDecimal.ONE)) {
            perdiemDays = BigDecimal.ONE;
        }
        calculationContext.setPerDiemDays(perdiemDays.add(BigDecimal.ONE));
    }
}

