/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.tech_addons;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class InitializeOperatingCosts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setOperatingHospitalSpecificPortionPart(calculationContext.getOperatingHospitalSpecificPortionPct().multiply(calculationContext.getOperatingHospitalSpecificPortionPart()).setScale(2, RoundingMode.HALF_UP));
        paymentData.setOperatingFederalSpecificPortionPart(calculationContext.getOperatingFederalSpecificPortionPct().multiply(calculationContext.getOperatingFederalSpecificPortionPart()).setScale(2, RoundingMode.HALF_UP));
        paymentData.setOperatingDisproportionateShareHospitalAdjustment(BigDecimal.ZERO);
        paymentData.setOperatingDisproportionateShareHospitalAdjustment(paymentData.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getOperatingDisproportionateShare()).multiply(new BigDecimal("0.25")).setScale(2, RoundingMode.HALF_UP));
        paymentData.setOperatingIndirectMedicalEducationAdjustment(paymentData.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getOperatingIndirectMedicalEducation()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setBaseDrgPayment(BigDecimalUtils.decimalSum(paymentData.getOperatingFederalSpecificPortionPart(), paymentData.getOperatingDisproportionateShareHospitalAdjustment(), paymentData.getOperatingIndirectMedicalEducationAdjustment(), calculationContext.getUncompensatedCareAmount()).setScale(2, RoundingMode.HALF_UP));
    }
}

