/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.tech_addons.technology;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.NewTechnologyAmountTableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class CalculateTechnologyAddOnCost
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    protected BigDecimal calculateBaseAdjustedCharges(IppsPricerContext calculationContext) {
        return calculationContext.getClaimData().getCoveredCharges().multiply(calculationContext.getProviderData().getOperatingCostToChargeRatio()).subtract(calculationContext.getBaseDrgPayment());
    }

    protected void aggregateNewTechCost(IppsPricerContext calculationContext, NewTechnologyAmountTableEntry technologyCostAmounts) {
        if (null != technologyCostAmounts) {
            BigDecimal adjustedCharges = this.calculateBaseAdjustedCharges(calculationContext).multiply(technologyCostAmounts.getAdjustmentFactor());
            BigDecimal newTechAddOn = BigDecimal.ZERO;
            if (BigDecimalUtils.isGreaterThanZero(adjustedCharges)) {
                newTechAddOn = BigDecimalUtils.isLessThan(technologyCostAmounts.getAmount(), adjustedCharges) ? technologyCostAmounts.getAmount() : adjustedCharges;
            }
            calculationContext.setNewTechAddOnPayment(calculationContext.getNewTechAddOnPayment().add(newTechAddOn).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

