/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateHospitalAcquiredConditionReduction
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal hacTotalPayment = BigDecimalUtils.decimalSum(paymentData.getOperatingHospitalSpecificPortionPart(), paymentData.getOperatingFederalSpecificPortionPart(), paymentData.getOperatingIndirectMedicalEducationAdjustment(), paymentData.getOperatingDisproportionateShareHospitalAdjustment(), paymentData.getOperatingOutlierPaymentPart(), calculationContext.getCapitalTotalPayment(), calculationContext.getUncompensatedCareAmount(), calculationContext.getNewTechAddOnPayment(), calculationContext.getLowVolumePayment(), calculationContext.getReadmissionAdjustmentAmount(), calculationContext.getValueBasedPurchasingAdjustmentAmount()).setScale(2, RoundingMode.HALF_UP);
        calculationContext.setHospitalAcquiredConditionAmount(BigDecimal.ZERO);
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (calculationContext.isStatePuertoRico() && StringUtils.equals(providerData.getHacReductionParticipantIndicator(), "Y")) {
            calculationContext.applyResultCode(ResultCode.RC_53_WAIVER_STATE_NOT_CALC);
            calculationContext.clearAdditionalVariablesContextState();
        } else {
            if (StringUtils.equals(providerData.getHacReductionParticipantIndicator(), "Y")) {
                calculationContext.setHospitalAcquiredConditionAmount(hacTotalPayment.multiply(new BigDecimal("-0.01")).setScale(2, RoundingMode.HALF_UP));
            }
            paymentData.setTotalPayment(BigDecimalUtils.decimalSum(hacTotalPayment, calculationContext.getPassthroughAmountPlusMisc(), calculationContext.getBundledAdjustmentPayment(), calculationContext.getHospitalAcquiredConditionAmount(), calculationContext.getIsletIsolationPaymentAddOn()).setScale(2, RoundingMode.HALF_UP));
            calculationContext.setValueBasedPurchasingParticipant(providerData.getVbpParticipantIndicator());
            calculationContext.setValueBasedPurchasingAdjustment(providerData.getVbpAdjustment());
            calculationContext.setHrrParticipantIndicator(providerData.getHrrParticipantIndicator());
            calculationContext.setHospitalReadmissionReductionAdjustment(providerData.getHrrAdjustment() == null ? BigDecimal.ZERO : providerData.getHrrAdjustment());
        }
    }
}

