/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateLowVolumeTotals
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setOperatingDisproportionateShareHospitalAdjustment(BigDecimal.ZERO);
        paymentData.setOperatingDisproportionateShareHospitalAdjustment(paymentData.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getOperatingDisproportionateShare()).multiply(new BigDecimal("0.25")).setScale(2, RoundingMode.HALF_UP));
        if (!calculationContext.isHmoClaim()) {
            paymentData.setOperatingIndirectMedicalEducationAdjustment(paymentData.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getOperatingIndirectMedicalEducation()).setScale(2, RoundingMode.HALF_UP));
        }
        paymentData.setOperatingFederalSpecificPortionPart(calculationContext.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getOperatingFederalSpecificPortionPct()).setScale(2, RoundingMode.HALF_UP));
        paymentData.setOperatingHospitalSpecificPortionPart(calculationContext.getOperatingHospitalSpecificPortionPart().multiply(calculationContext.getOperatingHospitalSpecificPortionPct()).setScale(2, RoundingMode.HALF_UP));
        paymentData.setOperatingOutlierPaymentPart(calculationContext.getOperatingOutlierPart().multiply(calculationContext.getOperatingFederalSpecificPortionPct()).setScale(2, RoundingMode.HALF_UP));
        BigDecimal lowVolAddon = BigDecimal.ZERO;
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getTemporaryReliefIndicator(), "Y") && BigDecimalUtils.isGreaterThanZero(providerData.getLowVolumeAdjustmentFactor()) && BigDecimalUtils.isLessThanOrEqualTo(providerData.getLowVolumeAdjustmentFactor(), new BigDecimal("0.25"))) {
            lowVolAddon = BigDecimalUtils.decimalSum(paymentData.getOperatingHospitalSpecificPortionPart(), paymentData.getOperatingFederalSpecificPortionPart(), paymentData.getOperatingIndirectMedicalEducationAdjustment(), paymentData.getOperatingDisproportionateShareHospitalAdjustment(), paymentData.getOperatingOutlierPaymentPart(), calculationContext.getCapitalFederalSpecificPortion(), calculationContext.getCapitalIndirectMedicalEducationAdj(), calculationContext.getCapitalDisproportionateShareHospitalAdjustment(), calculationContext.getCapitalOutlierCost(), calculationContext.getUncompensatedCareAmount(), calculationContext.getNewTechAddOnPayment()).multiply(providerData.getLowVolumeAdjustmentFactor()).setScale(2, RoundingMode.HALF_UP);
        }
        calculationContext.setLowVolumePayment(lowVolAddon);
    }
}

