/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2020.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import gov.cms.fiss.pricers.ipps.core.tables.PrevYearWIFY19TableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class AdjustIndexForPreviousYear2020
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        BigDecimal prevWageIndexAdjustment = this.prevWageIndexCheck(calculationContext);
        if (prevWageIndexAdjustment != null) {
            if (BigDecimalUtils.isZero(prevWageIndexAdjustment)) {
                calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
                return;
            }
            if (BigDecimalUtils.isLessThan(cbsaReference.getWageIndex().subtract(prevWageIndexAdjustment).divide(prevWageIndexAdjustment, RoundingMode.HALF_UP), calculationContext.getWageIndexPctReduction())) {
                cbsaReference.setWageIndex(prevWageIndexAdjustment.multiply(calculationContext.getWageIndexPctAdj()).setScale(4, RoundingMode.HALF_UP));
            }
        } else {
            calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
        }
    }

    protected BigDecimal prevWageIndexCheck(IppsPricerContext calculationContext) {
        BigDecimal prevWageIndexAdjustment = BigDecimal.ZERO;
        String providerNumber = calculationContext.getProviderData().getProviderCcn();
        String truncatedProviderNumber = StringUtils.truncate(providerNumber, 6);
        PrevYearWIFY19TableEntry prevYearWIFY19TableEntry = calculationContext.getDataTables().getPrevWageIndex(truncatedProviderNumber);
        if (prevYearWIFY19TableEntry != null) {
            prevWageIndexAdjustment = prevYearWIFY19TableEntry.getPrevWageIndex();
        }
        return prevWageIndexAdjustment;
    }
}

