/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2023.assemble_variables;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import java.time.LocalDate;

public class DetermineCovidAdjustment2023
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsClaimData claimData;
        DataTables dataTables = calculationContext.getDataTables();
        if (dataTables.codesMatch("COVID2", ClaimCodeType.DIAG, (claimData = calculationContext.getClaimData()).getDiagnosisCodes()) && !dataTables.codesMatch("COVID1", ClaimCodeType.COND, claimData.getConditionCodes()) && LocalDateUtils.isBeforeOrEqual(calculationContext.getDischargeDate(), LocalDate.of(2023, 5, 11))) {
            calculationContext.setCovidAdjustmentFactor(calculationContext.getCovidAdjustmentFactorValue());
        }
    }
}

