/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2023.assemble_variables;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;

public class DetermineNewCovid19TreatmentsAddOnPayment2023
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    private static final String CODE_PAXLOVID = "PAXLOVID";
    private static final String CODE_MOLNUPIRAVIR = "MOLNUPIRAVIR";
    private static final String CODE_KINERET = "KINERET";
    private static final String CODE_GOHIBIC = "GOHIBIC";

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        boolean isNctapEuas;
        IppsClaimData claimData;
        DataTables dataTables = calculationContext.getDataTables();
        boolean isNctap2021 = (dataTables.codesMatch("COVID1", ClaimCodeType.PROC, (claimData = calculationContext.getClaimData()).getProcedureCodes()) || dataTables.codesMatch("COVID3", ClaimCodeType.PROC, claimData.getProcedureCodes())) && LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), LocalDate.of(2021, 1, 1));
        boolean bl = isNctapEuas = dataTables.codesMatch(CODE_PAXLOVID, ClaimCodeType.NDC, claimData.getNationalDrugCodes()) || dataTables.codesMatch(CODE_MOLNUPIRAVIR, ClaimCodeType.NDC, claimData.getNationalDrugCodes()) || dataTables.codesMatch(CODE_KINERET, ClaimCodeType.NDC, claimData.getNationalDrugCodes()) && LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), LocalDate.of(2022, 11, 8)) || dataTables.codesMatch(CODE_GOHIBIC, ClaimCodeType.NDC, claimData.getNationalDrugCodes()) && LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), LocalDate.of(2023, 4, 4));
        if (dataTables.codesMatch("COVID2", ClaimCodeType.DIAG, claimData.getDiagnosisCodes()) && !dataTables.codesMatch("COVID1", ClaimCodeType.COND, claimData.getConditionCodes()) && (isNctap2021 || isNctapEuas)) {
            this.newCovid19TreatmentsAddOnPaymentValue(calculationContext);
        }
        calculationContext.setOperatingBaseDrgPayment(calculationContext.getOperatingBaseDrgPayment().add(calculationContext.getNewCovid19TreatmentsAddOnPayment()).setScale(2, RoundingMode.HALF_UP));
        calculationContext.setNewTechAddOnPayment(calculationContext.getNewTechAddOnPayment().add(calculationContext.getNewCovid19TreatmentsAddOnPayment()).setScale(2, RoundingMode.HALF_UP));
    }

    protected void newCovid19TreatmentsAddOnPaymentValue(IppsPricerContext calculationContext) {
        DataTables dataTables = calculationContext.getDataTables();
        IppsClaimData claimData = calculationContext.getClaimData();
        BigDecimal lesserNCTAP1 = calculationContext.getOperatingDollarThreshold().multiply(new BigDecimal("0.65"));
        BigDecimal lesserNCTAP2 = dataTables.codesMatch("VEKLURY", ClaimCodeType.PROC, claimData.getProcedureCodes()) ? calculationContext.getOperatingBillCosts().subtract(calculationContext.getOperatingCostOutlier().subtract(calculationContext.getOperatingDollarThreshold()).subtract(new BigDecimal("2028.00"))).multiply(new BigDecimal("0.65")) : calculationContext.getOperatingBillCosts().subtract(calculationContext.getOperatingCostOutlier().subtract(calculationContext.getOperatingDollarThreshold())).multiply(new BigDecimal("0.65"));
        if (BigDecimalUtils.isGreaterThan(calculationContext.getOperatingBillCosts(), calculationContext.getOperatingCostOutlier().subtract(calculationContext.getOperatingDollarThreshold()))) {
            if (BigDecimalUtils.isLessThan(lesserNCTAP1, lesserNCTAP2)) {
                calculationContext.setNewCovid19TreatmentsAddOnPayment(lesserNCTAP1);
            } else {
                calculationContext.setNewCovid19TreatmentsAddOnPayment(lesserNCTAP2);
            }
        }
        if (dataTables.codesMatch("VEKLURY", ClaimCodeType.PROC, claimData.getProcedureCodes())) {
            calculationContext.setNewCovid19TreatmentsAddOnPayment(calculationContext.getNewCovid19TreatmentsAddOnPayment().subtract(new BigDecimal("2028.00")));
        }
        if (BigDecimalUtils.isGreaterThan(calculationContext.getNewCovid19TreatmentsAddOnPayment(), BigDecimal.ZERO)) {
            calculationContext.setNewCovid19TreatmentsAddOnPayment(calculationContext.getNewCovid19TreatmentsAddOnPayment());
        } else {
            calculationContext.setNewCovid19TreatmentsAddOnPayment(BigDecimal.ZERO);
        }
    }
}

