/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.rules2023.wage_index;

import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.rules.wage_index.AdjustIndexForRuralFloor;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import java.math.BigDecimal;
import java.time.LocalDate;

public class AdjustIndexForRuralFloor2023
extends AdjustIndexForRuralFloor {
    @Override
    protected void adjustRuralFloor(IppsPricerContext calculationContext) {
        if (calculationContext.getCbsaLocation().length() > 2 || calculationContext.getCbsaLocation().length() == 2 && calculationContext.isCbsaSpecialPaymentIndicatorReclassified()) {
            CbsaReference cbsaReference;
            CbsaWageIndexEntry ruralCbsaTableEntry = calculationContext.getCbsaWageIndexEntry(calculationContext.getStateCode());
            BigDecimal ruralWi = BigDecimal.ZERO;
            if (ruralCbsaTableEntry != null) {
                LocalDate ruralCbsaTableEntryEffectiveDate = ruralCbsaTableEntry.getEffectiveDate();
                if (LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), ruralCbsaTableEntry.getEffectiveDate()) && LocalDateUtils.inRange(ruralCbsaTableEntryEffectiveDate, calculationContext.fiscalYearStart(), calculationContext.fiscalYearEnd())) {
                    ruralWi = ruralCbsaTableEntry.getGeographicWageIndex();
                }
            }
            if (BigDecimalUtils.isGreaterThan(ruralWi, (cbsaReference = calculationContext.getCbsaReference()).getWageIndex())) {
                if (ruralCbsaTableEntry == null) {
                    cbsaReference.setCbsa(null);
                    cbsaReference.setEffectiveDate(null);
                    cbsaReference.setWageIndex(null);
                } else {
                    cbsaReference.setCbsa(ruralCbsaTableEntry.getCbsa());
                    cbsaReference.setEffectiveDate(ruralCbsaTableEntry.getEffectiveDate());
                    cbsaReference.setWageIndex(ruralCbsaTableEntry.getGeographicWageIndex());
                }
                calculationContext.getProviderData().setSpecialPaymentIndicator("N");
                calculationContext.setCbsaLocation(calculationContext.getStateCode());
            }
        }
    }
}

