/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import org.apache.commons.lang3.StringUtils;

public class DeriveCbsaSize
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return ResultCode.RC_52_INVALID_WAGE_INDEX != calculationContext.getResultCode();
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaWageIndexEntry cbsaTableEntry = calculationContext.getCbsaWageIndexEntry();
        if (LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), cbsaTableEntry.getEffectiveDate())) {
            CbsaReference cbsaReference = calculationContext.getCbsaReference();
            InpatientProviderData providerData = calculationContext.getProviderData();
            CbsaWageIndexEntry stdAmtCbsaTableEntry = calculationContext.getDataTables().getCbsaWageIndexEntry(StringUtils.trim(providerData.getCbsaStandardizedAmountLocation()), cbsaTableEntry.getEffectiveDate());
            if (null == stdAmtCbsaTableEntry) {
                calculationContext.applyResultCode(ResultCode.RC_52_INVALID_WAGE_INDEX);
                calculationContext.setCalculationCompleted();
                return;
            }
            if (stdAmtCbsaTableEntry.getCbsa().length() == 2) {
                cbsaReference.setSize("R");
            } else if (StringUtils.equals(stdAmtCbsaTableEntry.getSize(), "L")) {
                cbsaReference.setSize("L");
            } else {
                cbsaReference.setSize("O");
            }
        }
    }
}

