/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.OutMigrationTableEntry;
import org.apache.commons.lang3.StringUtils;

public class ValidateOutMigration
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        String county = calculationContext.getProviderData().getCountyCode();
        OutMigrationTableEntry outMigrationTableEntry = calculationContext.getDataTables().getOutMigrationEntry(county, calculationContext.getDischargeDate(), calculationContext.fiscalYearStart());
        if ((StringUtils.isBlank(providerData.getCbsaWageIndexLocation()) || providerData.getCbsaWageIndexLocation().equals("00000")) && (StringUtils.isBlank(providerData.getCbsaStandardizedAmountLocation()) || providerData.getCbsaStandardizedAmountLocation().equals("00000")) && calculationContext.isCbsaSpecialPaymentIndicatorEmpty() && outMigrationTableEntry != null) {
            calculationContext.setOutMigrationAdjustment(outMigrationTableEntry.getAdjustmentFactor());
        }
    }
}

