/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeTableEntry;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClaimCodeTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/claim-codes-%s.csv";
    private final CsvContentReader<ClaimCodeTableEntry> contentProvider = new CsvContentReader<ClaimCodeTableEntry>(ClaimCodeTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public ClaimCodeTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, Map<ClaimCodeType, List<String>>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, Map<ClaimCodeType, List<String>>> generate(String csvFilename) {
        List<ClaimCodeTableEntry> content = this.contentProvider.read(csvFilename);
        Map mapByName = LookupGenerator.generateCrossReferenceToList(ClaimCodeTableEntry::getReferenceName, content, Collectors.mapping(Function.identity(), Collectors.toList()));
        HashMap<String, Map<ClaimCodeType, List<String>>> mapByNameAndCodeType = new HashMap<String, Map<ClaimCodeType, List<String>>>();
        mapByName.forEach((name, entries) -> mapByNameAndCodeType.put((String)name, LookupGenerator.generateCrossReferenceToList(ClaimCodeTableEntry::getCodeType, entries, Collectors.mapping(ClaimCodeTableEntry::getCode, Collectors.toList()))));
        return mapByNameAndCodeType;
    }
}

