/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import com.fasterxml.jackson.dataformat.csv.CsvParser;
import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class DrgsTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/drgstable-%s.csv";
    private final CsvContentReader<DrgsTableEntry> contentProvider = new CsvContentReader<DrgsTableEntry>(DrgsTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER).customizeMapper(m4 -> m4.enable(CsvParser.Feature.TRIM_SPACES));

    public DrgsTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NavigableMap<LocalDate, DrgsTableEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, NavigableMap<LocalDate, DrgsTableEntry>> generate(String csvFilename) {
        List<DrgsTableEntry> content = this.contentProvider.read(csvFilename);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<DrgsTableEntry, ?, NavigableMap> collector = Collectors.toMap(DrgsTableEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(DrgsTableEntry::getDiagnosticRelatedGroup, content, HashMap::new, collector);
    }
}

