/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.NewTechnologyAmountTableEntry;
import java.util.List;
import java.util.Map;

public class NewTechnologyAmountTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/newtech-costs-%s.csv";
    private final CsvContentReader<NewTechnologyAmountTableEntry> contentProvider = new CsvContentReader<NewTechnologyAmountTableEntry>(NewTechnologyAmountTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public NewTechnologyAmountTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NewTechnologyAmountTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, NewTechnologyAmountTableEntry> generate(String csvFilename) {
        List<NewTechnologyAmountTableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(NewTechnologyAmountTableEntry::getTechnologyName, content);
    }
}

