/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import io.dropwizard.health.HealthStateListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class State {
    private static final Logger LOGGER = LoggerFactory.getLogger(State.class);
    private final String name;
    private final int successAttempts;
    private final int failureAttempts;
    private final HealthStateListener healthStateListener;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicBoolean healthy;

    State(String name, int failureAttempts, int successAttempts, boolean initialState, HealthStateListener healthStateListener) {
        this.name = name;
        this.failureAttempts = failureAttempts;
        this.successAttempts = successAttempts;
        this.healthy = new AtomicBoolean(initialState);
        this.healthStateListener = healthStateListener;
    }

    void success() {
        if (this.healthy.get()) {
            return;
        }
        LOGGER.trace("health check received a successful result: name={} current={}", (Object)this.name, (Object)this.healthy);
        this.healthStateListener.onHealthyCheck(this.name);
        this.handleEvent(this.successAttempts, true);
    }

    void failure() {
        if (!this.healthy.get()) {
            return;
        }
        LOGGER.trace("health check received a failed result: name={} current={}", (Object)this.name, (Object)this.healthy);
        this.healthStateListener.onUnhealthyCheck(this.name);
        this.handleEvent(this.failureAttempts, false);
    }

    private void handleEvent(int numAttempts, boolean result) {
        int newCount = this.counter.incrementAndGet();
        LOGGER.debug("health check state update: name={} result={} count={}/{}", this.name, result, newCount, numAttempts);
        if (newCount >= numAttempts) {
            boolean newState = !this.healthy.get();
            this.healthy.set(newState);
            this.resetCount();
            this.healthStateListener.onStateChanged(this.name, newState);
        }
    }

    private void resetCount() {
        this.counter.set(0);
    }

    AtomicBoolean getHealthy() {
        return this.healthy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State state = (State)o;
        return this.successAttempts == state.successAttempts && this.failureAttempts == state.failureAttempts && Objects.equals(this.name, state.name) && Objects.equals(this.healthStateListener, state.healthStateListener) && Objects.equals(this.counter, state.counter) && Objects.equals(this.healthy, state.healthy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.successAttempts, this.failureAttempts, this.healthStateListener, this.counter, this.healthy);
    }

    public String toString() {
        return "State{name='" + this.name + "', successAttempts=" + this.successAttempts + ", failureAttempts=" + this.failureAttempts + ", healthStateListener=" + this.healthStateListener + ", counter=" + this.counter + ", healthy=" + this.healthy + "}";
    }
}

