/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.Index;

public class ContextRoutingHandler
extends AbstractHandlerContainer {
    private final Index<Handler> handlers;

    public ContextRoutingHandler(Map<String, ? extends Handler> handlers) {
        Index.Builder<Handler> builder = new Index.Builder().caseSensitive(false);
        for (Map.Entry<String, ? extends Handler> entry : handlers.entrySet()) {
            builder.with(entry.getKey(), entry.getValue());
            this.addBean(entry.getValue());
        }
        this.handlers = builder.build();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Handler handler = this.handlers.getBest(baseRequest.getRequestURI());
        if (handler != null) {
            handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        for (String key : this.handlers.keySet()) {
            this.handlers.get(key).start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        for (String key : this.handlers.keySet()) {
            this.handlers.get(key).stop();
        }
    }

    @Override
    public Handler[] getHandlers() {
        return (Handler[])this.handlers.keySet().stream().map(this.handlers::get).toArray(Handler[]::new);
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        Handler[] handlerArray = this.getHandlers();
        if (handlerArray != null) {
            for (Handler h2 : handlerArray) {
                this.expandHandler(h2, list, byClass);
            }
        }
    }
}

