/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import io.dropwizard.logging.common.AbstractAppenderFactory;
import io.dropwizard.logging.common.async.AsyncAppenderFactory;
import io.dropwizard.logging.common.filter.LevelFilterFactory;
import io.dropwizard.logging.common.layout.LayoutFactory;

public abstract class AbstractOutputStreamAppenderFactory<E extends DeferredProcessingAware>
extends AbstractAppenderFactory<E> {
    protected abstract OutputStreamAppender<E> appender(LoggerContext var1);

    @Override
    public Appender<E> build(LoggerContext context, String applicationName, LayoutFactory<E> layoutFactory, LevelFilterFactory<E> levelFilterFactory, AsyncAppenderFactory<E> asyncAppenderFactory) {
        OutputStreamAppender appender = this.appender(context);
        LayoutWrappingEncoder<E> layoutEncoder = new LayoutWrappingEncoder<E>();
        layoutEncoder.setLayout(this.buildLayout(context, layoutFactory));
        appender.setEncoder(layoutEncoder);
        appender.addFilter(levelFilterFactory.build(this.threshold));
        this.getFilterFactories().forEach(f -> appender.addFilter(f.build()));
        appender.start();
        return this.wrapAsync(appender, asyncAppenderFactory);
    }
}

