/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;

public class PricerYearReference<I, O> {
    private final Map<Integer, NavigableMap<LocalDate, PricerReference<I, O>>> references = new HashMap<Integer, NavigableMap<LocalDate, PricerReference<I, O>>>();
    private final Map<Class<? extends ClaimProcessor<I, O>>, Constructor<? extends ClaimProcessor<I, O>>> instantiationReference = new HashMap<Class<? extends ClaimProcessor<I, O>>, Constructor<? extends ClaimProcessor<I, O>>>();

    public PricerYearReference<I, O> register(int supportedYear, Class<? extends ClaimProcessor<I, O>> processorClass, Object ... constructorArguments) {
        return this.register(supportedYear, LocalDate.EPOCH, processorClass, constructorArguments);
    }

    public PricerYearReference<I, O> register(int supportedYear, LocalDate effectiveDate, Class<? extends ClaimProcessor<I, O>> processorClass, Object ... constructorArguments) {
        NavigableMap effectivePricers = this.references.computeIfAbsent(supportedYear, k -> new TreeMap());
        effectivePricers.put(effectiveDate, new PricerReference(processorClass, constructorArguments));
        return this;
    }

    public ClaimProcessor<I, O> fromCalendarYear(LocalDate referenceDate, String sourceField) throws YearNotImplementedException, InternalPricerException {
        int calendarYear = referenceDate.getYear();
        if (this.references.containsKey(calendarYear)) {
            return this.getInstance(calendarYear, referenceDate);
        }
        throw new YearNotImplementedException(referenceDate, sourceField);
    }

    public ClaimProcessor<I, O> fromFiscalYear(LocalDate referenceDate, String sourceField) throws YearNotImplementedException, InternalPricerException {
        int fiscalYear = LocalDateUtils.toFiscalYear(referenceDate);
        if (this.references.containsKey(fiscalYear)) {
            return this.getInstance(fiscalYear, referenceDate);
        }
        throw new YearNotImplementedException(referenceDate, sourceField);
    }

    private ClaimProcessor<I, O> getInstance(int supportedYear, LocalDate effectiveDate) throws InternalPricerException, YearNotImplementedException {
        try {
            NavigableMap<LocalDate, PricerReference<I, O>> effectivePricers = this.references.get(supportedYear);
            Map.Entry<LocalDate, PricerReference<I, O>> matchingReference = effectivePricers.floorEntry(effectiveDate);
            if (null == matchingReference) {
                throw new YearNotImplementedException(effectiveDate, "<effectiveClaimDate>");
            }
            PricerReference<I, O> yearReference = matchingReference.getValue();
            Constructor<ClaimProcessor<I, O>> instanceConstructor = this.instantiationReference.get(yearReference.getProcessorClass());
            if (null == instanceConstructor) {
                instanceConstructor = yearReference.getProcessorClass().getConstructor(yearReference.argumentClasses());
                this.instantiationReference.put(yearReference.getProcessorClass(), instanceConstructor);
            }
            return instanceConstructor.newInstance(yearReference.constructorArguments);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalPricerException(e);
        }
    }

    private static final class PricerReference<I, O> {
        private final Class<? extends ClaimProcessor<I, O>> processorClass;
        private final Object[] constructorArguments;

        Class<?>[] argumentClasses() {
            return (Class[])Arrays.stream(this.constructorArguments).map(Object::getClass).toArray(Class[]::new);
        }

        @Generated
        public PricerReference(Class<? extends ClaimProcessor<I, O>> processorClass, Object[] constructorArguments) {
            this.processorClass = processorClass;
            this.constructorArguments = constructorArguments;
        }

        @Generated
        public Class<? extends ClaimProcessor<I, O>> getProcessorClass() {
            return this.processorClass;
        }

        @Generated
        public Object[] getConstructorArguments() {
            return this.constructorArguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PricerReference)) {
                return false;
            }
            PricerReference other = (PricerReference)o;
            Class<ClaimProcessor<I, O>> this$processorClass = this.getProcessorClass();
            Class<ClaimProcessor<I, O>> other$processorClass = other.getProcessorClass();
            if (this$processorClass == null ? other$processorClass != null : !this$processorClass.equals(other$processorClass)) {
                return false;
            }
            return Arrays.deepEquals(this.getConstructorArguments(), other.getConstructorArguments());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<ClaimProcessor<I, O>> $processorClass = this.getProcessorClass();
            result = result * 59 + ($processorClass == null ? 43 : $processorClass.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getConstructorArguments());
            return result;
        }

        @Generated
        public String toString() {
            return "PricerYearReference.PricerReference(processorClass=" + this.getProcessorClass() + ", constructorArguments=" + Arrays.deepToString(this.getConstructorArguments()) + ")";
        }
    }
}

