/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import java.math.BigDecimal;
import org.apache.commons.lang3.ArrayUtils;

public class AnalyzeOutlierCalculationResults
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return !ArrayUtils.contains((Object[])new ResultCode[]{ResultCode.RC_65_PAY_CODE_NOT_ABC, ResultCode.RC_67_OUTLIER_LOS_GT_COVERED_DAYS, ResultCode.RC_68_INVALID_VBPF_IN_PSF}, (Object)calculationContext.getResultCode());
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        DrgsTableEntry drgsTableEntry = calculationContext.getDrgsTableEntry();
        IppsClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isPayTransferSpecialDrug() && BigDecimalUtils.isLessThan(calculationContext.getPerDiemDays(), drgsTableEntry.getGeometricMeanLengthOfStay()) && !claimData.getDiagnosisRelatedGroup().equals("789")) {
            if (calculationContext.isDrgPostacute5050()) {
                calculationContext.applyResultCode(ResultCode.RC_10_POST_ACUTE_XFER);
            }
            if (calculationContext.isDrgPostacutePerDiem()) {
                calculationContext.applyResultCode(ResultCode.RC_12_POST_ACUTE_XFER_WITH_DRGS);
            }
        }
        if (calculationContext.isPayPerDiemDays()) {
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getOperatingOutlierCostPart())) {
                calculationContext.setOperatingOutlierPart(calculationContext.getOperatingOutlierCostPart());
                calculationContext.applyResultCode(ResultCode.RC_05_TRANSFER_PAID_ON_A_PERDIEM_BASIS);
            } else if (ResultCode.RC_03_TRANSFER_PAID_PERDIEM_DAYS != calculationContext.getResultCode()) {
                calculationContext.applyResultCode(ResultCode.RC_00_OK);
                calculationContext.setOperatingOutlierPart(BigDecimal.ZERO);
            }
            if (BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalOutlierCostPart())) {
                calculationContext.setCapitalOutlierPart(calculationContext.getCapitalOutlierCostPart());
                calculationContext.applyResultCode(ResultCode.RC_05_TRANSFER_PAID_ON_A_PERDIEM_BASIS);
            } else if (ResultCode.RC_03_TRANSFER_PAID_PERDIEM_DAYS != calculationContext.getResultCode()) {
                calculationContext.setCapitalOutlierPart(BigDecimal.ZERO);
            }
        }
    }
}

