/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateCapitalIndirectMedicalEducation
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal capitalIndirectMedicalEducationRatio = BigDecimal.ZERO;
        if (providerData.getCapitalIndirectMedicalEducationRatio() != null) {
            capitalIndirectMedicalEducationRatio = providerData.getCapitalIndirectMedicalEducationRatio();
        }
        if (BigDecimalUtils.isGreaterThan(capitalIndirectMedicalEducationRatio, new BigDecimal("1.5"))) {
            capitalIndirectMedicalEducationRatio = new BigDecimal("1.5");
        }
        calculationContext.setCapitalIndirectMedicalEducation(BigDecimalUtils.pow(new BigDecimal("2.7183"), new BigDecimal("0.2822").multiply(capitalIndirectMedicalEducationRatio), 100).subtract(BigDecimal.ONE).setScale(9, RoundingMode.HALF_UP));
    }
}

