/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateOutlierThresholdAmounts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsClaimData claimData = calculationContext.getClaimData();
        DrgsTableEntry drgsTableEntry = calculationContext.getDrgsTableEntry();
        calculationContext.setCostThreshold(calculationContext.getCostThresholdBase());
        if (StringUtils.equals(claimData.getReviewCode(), "03") && BigDecimalUtils.isLessThan(calculationContext.getPerDiemDays(), drgsTableEntry.getGeometricMeanLengthOfStay())) {
            calculationContext.setCostThreshold(calculationContext.getCostThreshold().multiply(calculationContext.getTransferAdjustment()).setScale(2, RoundingMode.HALF_UP));
        }
        if (StringUtils.equals(claimData.getReviewCode(), "09") && BigDecimalUtils.isLessThan(calculationContext.getPerDiemDays(), drgsTableEntry.getGeometricMeanLengthOfStay()) && calculationContext.isDrgPostacutePerDiem()) {
            calculationContext.setCostThreshold(calculationContext.getCostThreshold().multiply(calculationContext.getTransferAdjustment()).setScale(2, RoundingMode.HALF_UP));
        }
        if (StringUtils.equals(claimData.getReviewCode(), "09") && BigDecimalUtils.isLessThan(calculationContext.getPerDiemDays(), drgsTableEntry.getGeometricMeanLengthOfStay()) && calculationContext.isDrgPostacute5050()) {
            calculationContext.setCostThreshold(calculationContext.getCostThreshold().multiply(calculationContext.getDischargeFraction()).setScale(2, RoundingMode.HALF_UP));
        }
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        calculationContext.setOperatingDollarThreshold(calculationContext.getOperatingShareDollarThreshold().multiply(calculationContext.getCostThreshold().multiply(calculationContext.getNationalLaborPct().multiply(cbsaReference.getWageIndex())).add(calculationContext.getCostThreshold().multiply(calculationContext.getNationalNonLaborPct().multiply(calculationContext.getOperatingCostOfLivingAdjustment())))).setScale(9, RoundingMode.HALF_UP));
        BigDecimal capitalDollarThreshold = calculationContext.getCapitalShareDollarThreshold().multiply(calculationContext.getCapitalCostOfLivingAdjustment()).multiply(calculationContext.getCapitalLargeUrbanFactor()).multiply(calculationContext.getCapitalGeographicAdjFactor()).multiply(calculationContext.getCostThreshold()).setScale(9, RoundingMode.HALF_UP);
        calculationContext.setOperatingCostOutlier(calculationContext.getOperatingFederalSpecificPortionPart().multiply(BigDecimal.ONE.add(calculationContext.getOperatingIndirectMedicalEducation())).add(calculationContext.getOperatingFederalSpecificPortionPart().multiply(calculationContext.getOperatingDisproportionateShare()).multiply(new BigDecimal("0.25"))).add(calculationContext.getOperatingDollarThreshold()).add(calculationContext.getUncompensatedCareAmount()).add(calculationContext.getNewTechAddOnPayment()).setScale(9, RoundingMode.HALF_UP));
        calculationContext.setCapitalCostOutlier(capitalDollarThreshold.add(calculationContext.getCapitalFederalSpecificPortionPart().multiply(BigDecimal.ONE.add(calculationContext.getCapitalIndirectMedicalEducation().add(calculationContext.getCapitalDisproportionateShareHospital())))).setScale(9, RoundingMode.HALF_UP));
        calculationContext.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalCostOutlier(calculationContext.getCapitalCostOutlier());
        if (StringUtils.equals(calculationContext.getProviderData().getNewHospital(), "Y")) {
            calculationContext.setCapitalCostOutlier(BigDecimal.ZERO);
            calculationContext.getAdditionalVariables().getAdditionalCapitalVariables().setCapitalCostOutlier(BigDecimal.ZERO);
        }
    }
}

