/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.PrevYearWIFY19TableEntry;
import java.util.List;
import java.util.Map;

public class PrevYearWIFY19TableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/prev-%s.csv";
    private final CsvContentReader<PrevYearWIFY19TableEntry> contentProvider = new CsvContentReader<PrevYearWIFY19TableEntry>(PrevYearWIFY19TableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public PrevYearWIFY19TableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, PrevYearWIFY19TableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, PrevYearWIFY19TableEntry> generate(String csvFilename) {
        List<PrevYearWIFY19TableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(PrevYearWIFY19TableEntry::getProvider, content);
    }
}

