// Generated by delombok at Thu Nov 13 21:38:37 UTC 2025
package gov.cms.fiss.pricers.ipps.api.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithElevenFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithNineFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Schema(description = "The additional variable information from claim pricing.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-ADDITIONAL-VARIABLES", value = "<structure>")})})
public class AdditionalCalculationVariableData {
  @NotNull
  @Valid
  private AdditionalCapitalVariableData additionalCapitalVariables = new AdditionalCapitalVariableData();
  @NotNull
  @Valid
  private AdditionalOperatingVariableData additionalOperatingVariables = new AdditionalOperatingVariableData();
  @NotNull
  @Valid
  private AdditionalPaymentInformationData additionalPaymentInformation = new AdditionalPaymentInformationData();
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The claim cost threshold.", example = "54364.62", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-CST-THRESH", value = "PIC 9(05)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal costThreshold;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The discharge fraction.", example = "3.8745", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DSCHG-FRCTN", value = "PIC 9(1)V9999")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal dischargeFraction;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99.9999")
  @Digits(integer = 2, fraction = 4)
  @Schema(description = "The diagnosis-related group (DRG) relative weight.", example = "89.4756", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DRG-WT", value = "PIC 9(02)V9(04)")})})
  @FixedValue
  private BigDecimal drgRelativeWeight;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The diagnosis-related group (DRG) relative weight fraction.", example = "87.5233", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DRG-WT-FRCTN", value = "PIC 9(02)V9999")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal drgRelativeWeightFraction;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The federal-specific portion percent.", example = "0.43", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FSP-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal federalSpecificPortionPercent;
  // value is not used
  @JsonIgnore
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal flx7Payment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP); // this
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The hospital readmission reduction adjustment.", example = "1.2353", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-HOSP-HRR-ADJUSTMT", value = "PIC 9V9(4)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal hospitalReadmissionReductionAdjustment;
  @Pattern(regexp = "[01]", message = "must be `0` or `1`")
  @Schema(description = "The hospital readmission reduction indicator.", example = "0", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-HOSP-READMISSION-REDU", value = "PIC X")})})
  private String hospitalReadmissionReductionIndicator;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The hospital-specific portion percent.", example = "4.55", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-HSP-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal hospitalSpecificPortionPercent;
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The hospital-specific portion rate.", example = "1234.896525245", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-HSP-RATE", value = "PIC 9(08)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal hospitalSpecificPortionRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The islet isolation add-on payment.", example = "2094835.76", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-ISLET-ISOL-PAY-ADD-ON", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal isletIsolationAddOnPayment;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The low-volume payment.", example = "4958.76", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LOW-VOL-PAYMENT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal lowVolumePayment;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99999.99")
  @Digits(integer = 5, fraction = 2)
  @Schema(description = "The national labor cost.", example = "54364.62", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-LABOR", value = "PIC 9(05)V9(02)")})})
  @FixedValue
  private BigDecimal nationalLaborCost;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The national labor percent.", example = "0.5309", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-LABOR-PCT", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal nationalLaborPercent;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99999.99")
  @Digits(integer = 5, fraction = 2)
  @Schema(description = "The national non-labor cost.", example = "54364.62", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-NLABOR", value = "PIC 9(05)V9(02)")})})
  @FixedValue
  private BigDecimal nationalNonLaborCost;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The national non-labor percent.", example = "0.4691", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-NONLABOR-PCT", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal nationalNonLaborPercent;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The national percent.", example = "0.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal nationalPercent;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The new technology add-on payment.", example = "9485.76", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NEW-TECH-PAY-ADD-ON", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal newTechnologyAddOnPayment;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The calculated pass-through total.", example = "52.09")
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal passthroughTotalPlusMisc;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99999.99")
  @Digits(integer = 5, fraction = 2)
  @Schema(description = "The regular labor cost.", example = "54364.62", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-REG-LABOR", value = "PIC 9(05)V9(02)")})})
  @FixedValue
  private BigDecimal regularLaborCost;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("99999.99")
  @Digits(integer = 5, fraction = 2)
  @Schema(description = "The regular non-labor cost.", example = "54364.62", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-REG-NLABOR", value = "PIC 9(05)V9(02)")})})
  @FixedValue
  private BigDecimal regularNonLaborCost;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The regular percent.", example = "4.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-REG-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal regularPercent;
  @BigDecimalScale(scale = 11, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The new technology add-on payment.", example = "1.69398467593", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-VAL-BASED-PURCH-ADJUST", value = "PIC 9V9(11)")})})
  @ValidDecimalOutputWithElevenFractionDigits
  private BigDecimal valueBasedPurchasingAdjustmentAmount;
  @Pattern(regexp = "[YN]", message = "must be `Y` or `N`")
  @Schema(description = "Indicates whether the provider participates in Value-Based Purchasing (VBP).", example = "N", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-VAL-BASED-PURCH-PARTIPNT", value = "PIC X")})})
  private String valueBasedPurchasingParticipantIndicator;
  @JsonIgnore
  @Schema(description = "Wage index.", example = "4.5045", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-WAGE-INDEX", value = "PIC 9(02)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal wageIndex;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalCapitalVariableData getAdditionalCapitalVariables() {
    return this.additionalCapitalVariables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalOperatingVariableData getAdditionalOperatingVariables() {
    return this.additionalOperatingVariables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalPaymentInformationData getAdditionalPaymentInformation() {
    return this.additionalPaymentInformation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostThreshold() {
    return this.costThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDischargeFraction() {
    return this.dischargeFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDrgRelativeWeight() {
    return this.drgRelativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDrgRelativeWeightFraction() {
    return this.drgRelativeWeightFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalSpecificPortionPercent() {
    return this.federalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFlx7Payment() {
    return this.flx7Payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalReadmissionReductionAdjustment() {
    return this.hospitalReadmissionReductionAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHospitalReadmissionReductionIndicator() {
    return this.hospitalReadmissionReductionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalSpecificPortionPercent() {
    return this.hospitalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHospitalSpecificPortionRate() {
    return this.hospitalSpecificPortionRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getIsletIsolationAddOnPayment() {
    return this.isletIsolationAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumePayment() {
    return this.lowVolumePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborCost() {
    return this.nationalLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborPercent() {
    return this.nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborCost() {
    return this.nationalNonLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborPercent() {
    return this.nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalPercent() {
    return this.nationalPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNewTechnologyAddOnPayment() {
    return this.newTechnologyAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPassthroughTotalPlusMisc() {
    return this.passthroughTotalPlusMisc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegularLaborCost() {
    return this.regularLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegularNonLaborCost() {
    return this.regularNonLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRegularPercent() {
    return this.regularPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getValueBasedPurchasingAdjustmentAmount() {
    return this.valueBasedPurchasingAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getValueBasedPurchasingParticipantIndicator() {
    return this.valueBasedPurchasingParticipantIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageIndex() {
    return this.wageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalCapitalVariables(final AdditionalCapitalVariableData additionalCapitalVariables) {
    this.additionalCapitalVariables = additionalCapitalVariables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalOperatingVariables(final AdditionalOperatingVariableData additionalOperatingVariables) {
    this.additionalOperatingVariables = additionalOperatingVariables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalPaymentInformation(final AdditionalPaymentInformationData additionalPaymentInformation) {
    this.additionalPaymentInformation = additionalPaymentInformation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostThreshold(final BigDecimal costThreshold) {
    this.costThreshold = costThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeFraction(final BigDecimal dischargeFraction) {
    this.dischargeFraction = dischargeFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDrgRelativeWeight(final BigDecimal drgRelativeWeight) {
    this.drgRelativeWeight = drgRelativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDrgRelativeWeightFraction(final BigDecimal drgRelativeWeightFraction) {
    this.drgRelativeWeightFraction = drgRelativeWeightFraction;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalSpecificPortionPercent(final BigDecimal federalSpecificPortionPercent) {
    this.federalSpecificPortionPercent = federalSpecificPortionPercent;
  }

  @JsonIgnore
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFlx7Payment(final BigDecimal flx7Payment) {
    this.flx7Payment = flx7Payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalReadmissionReductionAdjustment(final BigDecimal hospitalReadmissionReductionAdjustment) {
    this.hospitalReadmissionReductionAdjustment = hospitalReadmissionReductionAdjustment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalReadmissionReductionIndicator(final String hospitalReadmissionReductionIndicator) {
    this.hospitalReadmissionReductionIndicator = hospitalReadmissionReductionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalSpecificPortionPercent(final BigDecimal hospitalSpecificPortionPercent) {
    this.hospitalSpecificPortionPercent = hospitalSpecificPortionPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHospitalSpecificPortionRate(final BigDecimal hospitalSpecificPortionRate) {
    this.hospitalSpecificPortionRate = hospitalSpecificPortionRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIsletIsolationAddOnPayment(final BigDecimal isletIsolationAddOnPayment) {
    this.isletIsolationAddOnPayment = isletIsolationAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumePayment(final BigDecimal lowVolumePayment) {
    this.lowVolumePayment = lowVolumePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborCost(final BigDecimal nationalLaborCost) {
    this.nationalLaborCost = nationalLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborPercent(final BigDecimal nationalLaborPercent) {
    this.nationalLaborPercent = nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborCost(final BigDecimal nationalNonLaborCost) {
    this.nationalNonLaborCost = nationalNonLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborPercent(final BigDecimal nationalNonLaborPercent) {
    this.nationalNonLaborPercent = nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalPercent(final BigDecimal nationalPercent) {
    this.nationalPercent = nationalPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNewTechnologyAddOnPayment(final BigDecimal newTechnologyAddOnPayment) {
    this.newTechnologyAddOnPayment = newTechnologyAddOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPassthroughTotalPlusMisc(final BigDecimal passthroughTotalPlusMisc) {
    this.passthroughTotalPlusMisc = passthroughTotalPlusMisc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularLaborCost(final BigDecimal regularLaborCost) {
    this.regularLaborCost = regularLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularNonLaborCost(final BigDecimal regularNonLaborCost) {
    this.regularNonLaborCost = regularNonLaborCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularPercent(final BigDecimal regularPercent) {
    this.regularPercent = regularPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchasingAdjustmentAmount(final BigDecimal valueBasedPurchasingAdjustmentAmount) {
    this.valueBasedPurchasingAdjustmentAmount = valueBasedPurchasingAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchasingParticipantIndicator(final String valueBasedPurchasingParticipantIndicator) {
    this.valueBasedPurchasingParticipantIndicator = valueBasedPurchasingParticipantIndicator;
  }

  @JsonIgnore
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageIndex(final BigDecimal wageIndex) {
    this.wageIndex = wageIndex;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AdditionalCalculationVariableData)) return false;
    final AdditionalCalculationVariableData other = (AdditionalCalculationVariableData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$additionalCapitalVariables = this.getAdditionalCapitalVariables();
    final java.lang.Object other$additionalCapitalVariables = other.getAdditionalCapitalVariables();
    if (this$additionalCapitalVariables == null ? other$additionalCapitalVariables != null : !this$additionalCapitalVariables.equals(other$additionalCapitalVariables)) return false;
    final java.lang.Object this$additionalOperatingVariables = this.getAdditionalOperatingVariables();
    final java.lang.Object other$additionalOperatingVariables = other.getAdditionalOperatingVariables();
    if (this$additionalOperatingVariables == null ? other$additionalOperatingVariables != null : !this$additionalOperatingVariables.equals(other$additionalOperatingVariables)) return false;
    final java.lang.Object this$additionalPaymentInformation = this.getAdditionalPaymentInformation();
    final java.lang.Object other$additionalPaymentInformation = other.getAdditionalPaymentInformation();
    if (this$additionalPaymentInformation == null ? other$additionalPaymentInformation != null : !this$additionalPaymentInformation.equals(other$additionalPaymentInformation)) return false;
    final java.lang.Object this$costThreshold = this.getCostThreshold();
    final java.lang.Object other$costThreshold = other.getCostThreshold();
    if (this$costThreshold == null ? other$costThreshold != null : !this$costThreshold.equals(other$costThreshold)) return false;
    final java.lang.Object this$dischargeFraction = this.getDischargeFraction();
    final java.lang.Object other$dischargeFraction = other.getDischargeFraction();
    if (this$dischargeFraction == null ? other$dischargeFraction != null : !this$dischargeFraction.equals(other$dischargeFraction)) return false;
    final java.lang.Object this$drgRelativeWeight = this.getDrgRelativeWeight();
    final java.lang.Object other$drgRelativeWeight = other.getDrgRelativeWeight();
    if (this$drgRelativeWeight == null ? other$drgRelativeWeight != null : !this$drgRelativeWeight.equals(other$drgRelativeWeight)) return false;
    final java.lang.Object this$drgRelativeWeightFraction = this.getDrgRelativeWeightFraction();
    final java.lang.Object other$drgRelativeWeightFraction = other.getDrgRelativeWeightFraction();
    if (this$drgRelativeWeightFraction == null ? other$drgRelativeWeightFraction != null : !this$drgRelativeWeightFraction.equals(other$drgRelativeWeightFraction)) return false;
    final java.lang.Object this$federalSpecificPortionPercent = this.getFederalSpecificPortionPercent();
    final java.lang.Object other$federalSpecificPortionPercent = other.getFederalSpecificPortionPercent();
    if (this$federalSpecificPortionPercent == null ? other$federalSpecificPortionPercent != null : !this$federalSpecificPortionPercent.equals(other$federalSpecificPortionPercent)) return false;
    final java.lang.Object this$flx7Payment = this.getFlx7Payment();
    final java.lang.Object other$flx7Payment = other.getFlx7Payment();
    if (this$flx7Payment == null ? other$flx7Payment != null : !this$flx7Payment.equals(other$flx7Payment)) return false;
    final java.lang.Object this$hospitalReadmissionReductionAdjustment = this.getHospitalReadmissionReductionAdjustment();
    final java.lang.Object other$hospitalReadmissionReductionAdjustment = other.getHospitalReadmissionReductionAdjustment();
    if (this$hospitalReadmissionReductionAdjustment == null ? other$hospitalReadmissionReductionAdjustment != null : !this$hospitalReadmissionReductionAdjustment.equals(other$hospitalReadmissionReductionAdjustment)) return false;
    final java.lang.Object this$hospitalReadmissionReductionIndicator = this.getHospitalReadmissionReductionIndicator();
    final java.lang.Object other$hospitalReadmissionReductionIndicator = other.getHospitalReadmissionReductionIndicator();
    if (this$hospitalReadmissionReductionIndicator == null ? other$hospitalReadmissionReductionIndicator != null : !this$hospitalReadmissionReductionIndicator.equals(other$hospitalReadmissionReductionIndicator)) return false;
    final java.lang.Object this$hospitalSpecificPortionPercent = this.getHospitalSpecificPortionPercent();
    final java.lang.Object other$hospitalSpecificPortionPercent = other.getHospitalSpecificPortionPercent();
    if (this$hospitalSpecificPortionPercent == null ? other$hospitalSpecificPortionPercent != null : !this$hospitalSpecificPortionPercent.equals(other$hospitalSpecificPortionPercent)) return false;
    final java.lang.Object this$hospitalSpecificPortionRate = this.getHospitalSpecificPortionRate();
    final java.lang.Object other$hospitalSpecificPortionRate = other.getHospitalSpecificPortionRate();
    if (this$hospitalSpecificPortionRate == null ? other$hospitalSpecificPortionRate != null : !this$hospitalSpecificPortionRate.equals(other$hospitalSpecificPortionRate)) return false;
    final java.lang.Object this$isletIsolationAddOnPayment = this.getIsletIsolationAddOnPayment();
    final java.lang.Object other$isletIsolationAddOnPayment = other.getIsletIsolationAddOnPayment();
    if (this$isletIsolationAddOnPayment == null ? other$isletIsolationAddOnPayment != null : !this$isletIsolationAddOnPayment.equals(other$isletIsolationAddOnPayment)) return false;
    final java.lang.Object this$lowVolumePayment = this.getLowVolumePayment();
    final java.lang.Object other$lowVolumePayment = other.getLowVolumePayment();
    if (this$lowVolumePayment == null ? other$lowVolumePayment != null : !this$lowVolumePayment.equals(other$lowVolumePayment)) return false;
    final java.lang.Object this$nationalLaborCost = this.getNationalLaborCost();
    final java.lang.Object other$nationalLaborCost = other.getNationalLaborCost();
    if (this$nationalLaborCost == null ? other$nationalLaborCost != null : !this$nationalLaborCost.equals(other$nationalLaborCost)) return false;
    final java.lang.Object this$nationalLaborPercent = this.getNationalLaborPercent();
    final java.lang.Object other$nationalLaborPercent = other.getNationalLaborPercent();
    if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !this$nationalLaborPercent.equals(other$nationalLaborPercent)) return false;
    final java.lang.Object this$nationalNonLaborCost = this.getNationalNonLaborCost();
    final java.lang.Object other$nationalNonLaborCost = other.getNationalNonLaborCost();
    if (this$nationalNonLaborCost == null ? other$nationalNonLaborCost != null : !this$nationalNonLaborCost.equals(other$nationalNonLaborCost)) return false;
    final java.lang.Object this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
    final java.lang.Object other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
    if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !this$nationalNonLaborPercent.equals(other$nationalNonLaborPercent)) return false;
    final java.lang.Object this$nationalPercent = this.getNationalPercent();
    final java.lang.Object other$nationalPercent = other.getNationalPercent();
    if (this$nationalPercent == null ? other$nationalPercent != null : !this$nationalPercent.equals(other$nationalPercent)) return false;
    final java.lang.Object this$newTechnologyAddOnPayment = this.getNewTechnologyAddOnPayment();
    final java.lang.Object other$newTechnologyAddOnPayment = other.getNewTechnologyAddOnPayment();
    if (this$newTechnologyAddOnPayment == null ? other$newTechnologyAddOnPayment != null : !this$newTechnologyAddOnPayment.equals(other$newTechnologyAddOnPayment)) return false;
    final java.lang.Object this$passthroughTotalPlusMisc = this.getPassthroughTotalPlusMisc();
    final java.lang.Object other$passthroughTotalPlusMisc = other.getPassthroughTotalPlusMisc();
    if (this$passthroughTotalPlusMisc == null ? other$passthroughTotalPlusMisc != null : !this$passthroughTotalPlusMisc.equals(other$passthroughTotalPlusMisc)) return false;
    final java.lang.Object this$regularLaborCost = this.getRegularLaborCost();
    final java.lang.Object other$regularLaborCost = other.getRegularLaborCost();
    if (this$regularLaborCost == null ? other$regularLaborCost != null : !this$regularLaborCost.equals(other$regularLaborCost)) return false;
    final java.lang.Object this$regularNonLaborCost = this.getRegularNonLaborCost();
    final java.lang.Object other$regularNonLaborCost = other.getRegularNonLaborCost();
    if (this$regularNonLaborCost == null ? other$regularNonLaborCost != null : !this$regularNonLaborCost.equals(other$regularNonLaborCost)) return false;
    final java.lang.Object this$regularPercent = this.getRegularPercent();
    final java.lang.Object other$regularPercent = other.getRegularPercent();
    if (this$regularPercent == null ? other$regularPercent != null : !this$regularPercent.equals(other$regularPercent)) return false;
    final java.lang.Object this$valueBasedPurchasingAdjustmentAmount = this.getValueBasedPurchasingAdjustmentAmount();
    final java.lang.Object other$valueBasedPurchasingAdjustmentAmount = other.getValueBasedPurchasingAdjustmentAmount();
    if (this$valueBasedPurchasingAdjustmentAmount == null ? other$valueBasedPurchasingAdjustmentAmount != null : !this$valueBasedPurchasingAdjustmentAmount.equals(other$valueBasedPurchasingAdjustmentAmount)) return false;
    final java.lang.Object this$valueBasedPurchasingParticipantIndicator = this.getValueBasedPurchasingParticipantIndicator();
    final java.lang.Object other$valueBasedPurchasingParticipantIndicator = other.getValueBasedPurchasingParticipantIndicator();
    if (this$valueBasedPurchasingParticipantIndicator == null ? other$valueBasedPurchasingParticipantIndicator != null : !this$valueBasedPurchasingParticipantIndicator.equals(other$valueBasedPurchasingParticipantIndicator)) return false;
    final java.lang.Object this$wageIndex = this.getWageIndex();
    final java.lang.Object other$wageIndex = other.getWageIndex();
    if (this$wageIndex == null ? other$wageIndex != null : !this$wageIndex.equals(other$wageIndex)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AdditionalCalculationVariableData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $additionalCapitalVariables = this.getAdditionalCapitalVariables();
    result = result * PRIME + ($additionalCapitalVariables == null ? 43 : $additionalCapitalVariables.hashCode());
    final java.lang.Object $additionalOperatingVariables = this.getAdditionalOperatingVariables();
    result = result * PRIME + ($additionalOperatingVariables == null ? 43 : $additionalOperatingVariables.hashCode());
    final java.lang.Object $additionalPaymentInformation = this.getAdditionalPaymentInformation();
    result = result * PRIME + ($additionalPaymentInformation == null ? 43 : $additionalPaymentInformation.hashCode());
    final java.lang.Object $costThreshold = this.getCostThreshold();
    result = result * PRIME + ($costThreshold == null ? 43 : $costThreshold.hashCode());
    final java.lang.Object $dischargeFraction = this.getDischargeFraction();
    result = result * PRIME + ($dischargeFraction == null ? 43 : $dischargeFraction.hashCode());
    final java.lang.Object $drgRelativeWeight = this.getDrgRelativeWeight();
    result = result * PRIME + ($drgRelativeWeight == null ? 43 : $drgRelativeWeight.hashCode());
    final java.lang.Object $drgRelativeWeightFraction = this.getDrgRelativeWeightFraction();
    result = result * PRIME + ($drgRelativeWeightFraction == null ? 43 : $drgRelativeWeightFraction.hashCode());
    final java.lang.Object $federalSpecificPortionPercent = this.getFederalSpecificPortionPercent();
    result = result * PRIME + ($federalSpecificPortionPercent == null ? 43 : $federalSpecificPortionPercent.hashCode());
    final java.lang.Object $flx7Payment = this.getFlx7Payment();
    result = result * PRIME + ($flx7Payment == null ? 43 : $flx7Payment.hashCode());
    final java.lang.Object $hospitalReadmissionReductionAdjustment = this.getHospitalReadmissionReductionAdjustment();
    result = result * PRIME + ($hospitalReadmissionReductionAdjustment == null ? 43 : $hospitalReadmissionReductionAdjustment.hashCode());
    final java.lang.Object $hospitalReadmissionReductionIndicator = this.getHospitalReadmissionReductionIndicator();
    result = result * PRIME + ($hospitalReadmissionReductionIndicator == null ? 43 : $hospitalReadmissionReductionIndicator.hashCode());
    final java.lang.Object $hospitalSpecificPortionPercent = this.getHospitalSpecificPortionPercent();
    result = result * PRIME + ($hospitalSpecificPortionPercent == null ? 43 : $hospitalSpecificPortionPercent.hashCode());
    final java.lang.Object $hospitalSpecificPortionRate = this.getHospitalSpecificPortionRate();
    result = result * PRIME + ($hospitalSpecificPortionRate == null ? 43 : $hospitalSpecificPortionRate.hashCode());
    final java.lang.Object $isletIsolationAddOnPayment = this.getIsletIsolationAddOnPayment();
    result = result * PRIME + ($isletIsolationAddOnPayment == null ? 43 : $isletIsolationAddOnPayment.hashCode());
    final java.lang.Object $lowVolumePayment = this.getLowVolumePayment();
    result = result * PRIME + ($lowVolumePayment == null ? 43 : $lowVolumePayment.hashCode());
    final java.lang.Object $nationalLaborCost = this.getNationalLaborCost();
    result = result * PRIME + ($nationalLaborCost == null ? 43 : $nationalLaborCost.hashCode());
    final java.lang.Object $nationalLaborPercent = this.getNationalLaborPercent();
    result = result * PRIME + ($nationalLaborPercent == null ? 43 : $nationalLaborPercent.hashCode());
    final java.lang.Object $nationalNonLaborCost = this.getNationalNonLaborCost();
    result = result * PRIME + ($nationalNonLaborCost == null ? 43 : $nationalNonLaborCost.hashCode());
    final java.lang.Object $nationalNonLaborPercent = this.getNationalNonLaborPercent();
    result = result * PRIME + ($nationalNonLaborPercent == null ? 43 : $nationalNonLaborPercent.hashCode());
    final java.lang.Object $nationalPercent = this.getNationalPercent();
    result = result * PRIME + ($nationalPercent == null ? 43 : $nationalPercent.hashCode());
    final java.lang.Object $newTechnologyAddOnPayment = this.getNewTechnologyAddOnPayment();
    result = result * PRIME + ($newTechnologyAddOnPayment == null ? 43 : $newTechnologyAddOnPayment.hashCode());
    final java.lang.Object $passthroughTotalPlusMisc = this.getPassthroughTotalPlusMisc();
    result = result * PRIME + ($passthroughTotalPlusMisc == null ? 43 : $passthroughTotalPlusMisc.hashCode());
    final java.lang.Object $regularLaborCost = this.getRegularLaborCost();
    result = result * PRIME + ($regularLaborCost == null ? 43 : $regularLaborCost.hashCode());
    final java.lang.Object $regularNonLaborCost = this.getRegularNonLaborCost();
    result = result * PRIME + ($regularNonLaborCost == null ? 43 : $regularNonLaborCost.hashCode());
    final java.lang.Object $regularPercent = this.getRegularPercent();
    result = result * PRIME + ($regularPercent == null ? 43 : $regularPercent.hashCode());
    final java.lang.Object $valueBasedPurchasingAdjustmentAmount = this.getValueBasedPurchasingAdjustmentAmount();
    result = result * PRIME + ($valueBasedPurchasingAdjustmentAmount == null ? 43 : $valueBasedPurchasingAdjustmentAmount.hashCode());
    final java.lang.Object $valueBasedPurchasingParticipantIndicator = this.getValueBasedPurchasingParticipantIndicator();
    result = result * PRIME + ($valueBasedPurchasingParticipantIndicator == null ? 43 : $valueBasedPurchasingParticipantIndicator.hashCode());
    final java.lang.Object $wageIndex = this.getWageIndex();
    result = result * PRIME + ($wageIndex == null ? 43 : $wageIndex.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "AdditionalCalculationVariableData(additionalCapitalVariables=" + this.getAdditionalCapitalVariables() + ", additionalOperatingVariables=" + this.getAdditionalOperatingVariables() + ", additionalPaymentInformation=" + this.getAdditionalPaymentInformation() + ", costThreshold=" + this.getCostThreshold() + ", dischargeFraction=" + this.getDischargeFraction() + ", drgRelativeWeight=" + this.getDrgRelativeWeight() + ", drgRelativeWeightFraction=" + this.getDrgRelativeWeightFraction() + ", federalSpecificPortionPercent=" + this.getFederalSpecificPortionPercent() + ", flx7Payment=" + this.getFlx7Payment() + ", hospitalReadmissionReductionAdjustment=" + this.getHospitalReadmissionReductionAdjustment() + ", hospitalReadmissionReductionIndicator=" + this.getHospitalReadmissionReductionIndicator() + ", hospitalSpecificPortionPercent=" + this.getHospitalSpecificPortionPercent() + ", hospitalSpecificPortionRate=" + this.getHospitalSpecificPortionRate() + ", isletIsolationAddOnPayment=" + this.getIsletIsolationAddOnPayment() + ", lowVolumePayment=" + this.getLowVolumePayment() + ", nationalLaborCost=" + this.getNationalLaborCost() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborCost=" + this.getNationalNonLaborCost() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", nationalPercent=" + this.getNationalPercent() + ", newTechnologyAddOnPayment=" + this.getNewTechnologyAddOnPayment() + ", passthroughTotalPlusMisc=" + this.getPassthroughTotalPlusMisc() + ", regularLaborCost=" + this.getRegularLaborCost() + ", regularNonLaborCost=" + this.getRegularNonLaborCost() + ", regularPercent=" + this.getRegularPercent() + ", valueBasedPurchasingAdjustmentAmount=" + this.getValueBasedPurchasingAdjustmentAmount() + ", valueBasedPurchasingParticipantIndicator=" + this.getValueBasedPurchasingParticipantIndicator() + ", wageIndex=" + this.getWageIndex() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalCalculationVariableData() {
  }
}
